<?php
namespace app\controllers;

use yii\web\Controller;
use app\models\Contest;
use yii\filters\AccessControl;

class ContestController extends Controller
{
    public function behaviors()
    {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'only'=>['index', 'view'],
                'rules'=>[['allow'=>true]],
            ],
        ];
    }

    public function actionIndex()
    {
        $contests = Contest::find()->all();
        return $this->render('index', ['contests' => $contests]);
    }

    public function actionView($id)
    {
        $model = Contest::findOne($id);
        if (!$model) {
            throw new NotFoundHttpException("Конкурс не найден");
        }

        return $this->render('view', [
            'model' => $model,
        ]);
    }

}
