<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Application;
use app\models\Evaluation;
use Mpdf\Mpdf;
use ZipArchive;

class ProtocolController extends Controller
{
    /**
     * Генерация итогового рейтингового протокола
     */
    public function actionGenerateProtocol($contest_id)
    {
        // Получаем заявки с оценками
        $applications = Application::find()
            ->where(['contest_id' => $contest_id])
            ->with('evaluations', 'user', 'nomination')
            ->all();

        $data = [];

        foreach ($applications as $app) {
            $scores = array_sum(array_map(fn($e) => $e->getTotal(), $app->evaluations));

            $data[] = [
                'fio' => $app->user->surname . ' ' . $app->user->name,
                'nomination' => $app->nomination->name,
                'score' => $scores,
            ];
        }

        // Сортировка по баллам
        usort($data, fn($a, $b) => $b['score'] <=> $a['score']);

        // Генерация PDF
        $mpdf = new Mpdf();
        $html = $this->renderPartial('protocol', [
            'data' => $data,
        ]);
        $mpdf->WriteHTML($html);

        return $mpdf->Output('protocol.pdf', 'I'); // I → показать в браузере
    }

    /**
     * Генерация дипломов ZIP
     */
    public function actionGenerateDiplomas($contest_id)
    {
        $applications = Application::find()
            ->where(['contest_id' => $contest_id])
            ->with('evaluations', 'user', 'nomination')
            ->all();

        // Папка
        $zipPath = Yii::getAlias('@runtime/diplomas_' . time() . '.zip');
        $zip = new ZipArchive;
        $zip->open($zipPath, ZipArchive::CREATE);

        foreach ($applications as $app) {

            $score = array_sum(array_map(fn($e) => $e->getTotal(), $app->evaluations));

            // Генерация PDF в строку
            $mpdf = new Mpdf();
            $html = $this->renderPartial('diploma', [
                'fio' => $app->user->surname . ' ' . $app->user->name,
                'contest' => $app->contest->title,
                'nomination' => $app->nomination->name,
                'score' => $score,
            ]);
            $mpdf->WriteHTML($html);

            // Добавляем PDF в ZIP
            $zip->addFromString("diploma_{$app->id}.pdf", $mpdf->Output('', 'S'));
        }

        $zip->close();

        return Yii::$app->response->sendFile($zipPath, 'diplomas.zip');
    }
}
