<?php
namespace app\models;

use Yii;
use yii\base\Model;

class ChangePasswordForm extends Model
{
    public $currentPassword;
    public $newPassword;
    public $newPasswordRepeat;

    public function rules()
    {
        return [
            [['currentPassword','newPassword','newPasswordRepeat'],'required'],
            ['newPassword','string','min'=>6],
            ['newPasswordRepeat','compare','compareAttribute'=>'newPassword','message'=>'Пароли должны совпадать'],
            ['currentPassword','validateCurrentPassword']
        ];
    }

    public function validateCurrentPassword($attribute, $params)
    {
        if (!Yii::$app->user->identity->validatePassword($this->$attribute)) {
            $this->addError($attribute,'Текущий пароль неверный');
        }
    }

    public function changePassword()
    {
        if (!$this->validate()) return false;
        $user = Yii::$app->user->identity;
        $user->password_hash = Yii::$app->security->generatePasswordHash($this->newPassword);
        return $user->save(false);
    }
}
