<?php

namespace app\models;

use yii\db\ActiveRecord;

class Contest extends ActiveRecord
{
    public static function tableName()
    {
        return 'contest';
    }

    public function rules()
    {
        return [
            [['title', 'start_date', 'end_date'], 'required'],
            [['description'], 'string'],
            [['image'], 'string', 'max' => 255],

        ];
    }

    public function getApplications()
    {
        return $this->hasMany(Application::class, ['contest_id' => 'id']);
    }

    public function getNominations() {
        return $this->hasMany(Nomination::class, ['id' => 'nomination_id'])
            ->viaTable('contest_nomination', ['contest_id' => 'id']);
    }

    public function getAgeCategories() {
        return $this->hasMany(AgeCategory::class, ['id' => 'age_category_id'])
            ->viaTable('contest_age_category', ['contest_id' => 'id']);
    }

}
