<?php
namespace app\models;

use yii\db\ActiveRecord;

class Evaluation extends ActiveRecord
{
    public static function tableName()
    {
        return 'evaluation';
    }

    public function rules()
    {
        return [
            [['application_id', 'expert_id'], 'required'],
            [['mastery','artistry','stage_culture'], 'integer', 'min' => 0, 'max' => 8],
            [['notes'], 'string'],
            [['status'], 'in', 'range' => ['draft','completed']],
        ];
    }

    public function getApplication()
    {
        return $this->hasOne(Application::class, ['id' => 'application_id']);
    }

    public function getExpert()
    {
        return $this->hasOne(User::class, ['id' => 'expert_id']);
    }

    /**
     * Возвращает сумму баллов
     */
    public function getTotal()
    {
        return ($this->mastery ?? 0) + ($this->artistry ?? 0) + ($this->stage_culture ?? 0);
    }

    /**
     * Возвращает средний балл (опционально)
     */
    public function getAverage()
    {
        $cnt = 0;
        $sum = 0;
        foreach (['mastery','artistry','stage_culture'] as $f) {
            if ($this->$f !== null) {
                $sum += $this->$f;
                $cnt++;
            }
        }
        return $cnt ? round($sum / $cnt, 2) : 0;
    }
}
