<?php

namespace app\models;

use Yii;
use yii\base\Model;

class RegisterForm extends Model
{
    public $name;
    public $surname;
    public $patronymic;
    public $login;
    public $email;
    public $password;
    public $password_repeat;
    public $rules;

    public function rules()
    {
        return [
            [['name', 'surname', 'login', 'email', 'password', 'password_repeat', 'rules'], 'required'],
            ['patronymic', 'safe'],

            ['password_repeat', 'compare', 'compareAttribute' => 'password', 'message' => 'Пароли должны совпадать'],

            ['password', 'string', 'min' => 6, 'message' => 'Пароль должен быть не менее 6 символов'],

            [['name', 'surname', 'patronymic'], 'match', 'pattern' => '/^[А-Яа-яЁё\s\-]+$/u', 'message' => 'Допустимы только кириллица, пробел и тире'],
            ['login', 'match', 'pattern' => '/^[a-zA-Z0-9\-]+$/', 'message' => 'Допустимы только латиница, цифры и тире'],

            ['email', 'email'],

            ['login', 'unique', 'targetClass' => '\app\models\User', 'message' => 'Этот логин уже занят'],
            ['email', 'unique', 'targetClass' => '\app\models\User', 'message' => 'Этот email уже занят'],

            ['rules', 'boolean'],
            ['rules', 'compare', 'compareValue' => true, 'message' => 'Вы должны согласиться с правилами'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'name' => 'Имя',
            'surname' => 'Фамилия',
            'patronymic' => 'Отчество',
            'login' => 'Логин',
            'email' => 'Email',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'rules' => 'Согласие с правилами',
        ];
    }


    public function register()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->name = $this->name;
        $user->surname = $this->surname;
        $user->patronymic = $this->patronymic;
        $user->login = $this->login;
        $user->email = $this->email;
        $user->setPassword($this->password);
        $user->role = User::ROLE_PARTICIPANT;
        $user->status = 1;

        return $user->save() ? $user : null;
    }
}
