<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>

<!-- Основной контент -->
<div id="age-category-update" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Редактирование возрастной категории</h2>
            <p class="text-gray-600 mt-2">
                ID: <span class="font-semibold">#<?= $model->id ?></span> |
                Текущее название: <span class="font-semibold"><?= Html::encode($model->name) ?></span>
            </p>
        </div>
        <?= Html::a('← Назад к категории', ['age-category-view', 'id' => $model->id], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная форма -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <div class="flex items-center mb-6">
                <div>
                    <h3 class="text-2xl font-bold text-gray-800">✏️ Редактирование данных</h3>
                    <p class="text-gray-600">Обновите информацию о возрастной категории</p>
                </div>
            </div>

            <?php $form = ActiveForm::begin([
                'id' => 'age-category-form',
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <!-- Название категории -->
            <div>
                <?= $form->field($model, 'name', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors text-lg font-medium',
                    'placeholder' => 'Введите новое название категории',
                    'id' => 'category-name'
                ])->label('🎯 Название категории *') ?>

                <!-- Автоматическое определение возраста -->
                <div id="age-detection" class="hidden mt-2 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                    <div class="flex items-center text-sm text-blue-700">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Определен возраст: от <span id="min-age">0</span> до <span id="max-age">0</span> лет</span>
                    </div>
                </div>
            </div>

            <!-- Описание (если есть в модели) -->
            <?php if (isset($model->description)): ?>
                <div>
                    <?= $form->field($model, 'description', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Опишите особенности этой возрастной группы</div>
                    '
                    ])->textarea([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'rows' => 3,
                        'placeholder' => 'Опишите особенности возрастной группы...',
                        'id' => 'category-description'
                    ])->label('📝 Описание категории') ?>
                </div>
            <?php endif; ?>

            <!-- Минимальный и максимальный возраст (если есть отдельные поля) -->
            <?php if (isset($model->min_age) && isset($model->max_age)): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <?= $form->field($model, 'min_age', [
                            'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                        ])->textInput([
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                            'type' => 'number',
                            'placeholder' => '6',
                            'min' => '0',
                            'max' => '100',
                            'id' => 'min-age-input'
                        ])->label('👶 Минимальный возраст') ?>
                    </div>

                    <div>
                        <?= $form->field($model, 'max_age', [
                            'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                        ])->textInput([
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                            'type' => 'number',
                            'placeholder' => '9',
                            'min' => '0',
                            'max' => '100',
                            'id' => 'max-age-input'
                        ])->label('👴 Максимальный возраст') ?>
                    </div>
                </div>

                <!-- Визуализация возраста -->
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                    <div class="flex justify-between text-sm text-gray-600 mb-2">
                        <span>0 лет</span>
                        <span>Диапазон возраста</span>
                        <span>18+ лет</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-3">
                        <div id="age-range-visual" class="bg-blue-600 h-3 rounded-full" style="width: <?= $this->getAgePercentage($model) ?>%"></div>
                    </div>
                    <div class="mt-2 text-center">

                    </div>
                </div>
            <?php endif; ?>

            <!-- Иконка (если есть в модели) -->
            <?php if (isset($model->icon)): ?>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">🎨 Иконка категории</label>


                    <?= $form->field($model, 'icon', [
                        'template' => '{input}{error}'
                    ])->hiddenInput(['id' => 'category-icon']) ?>
                </div>
            <?php endif; ?>



            <!-- Кнопки -->
            <div class="mt-8 flex space-x-4">
                <?= Html::submitButton('💾 Сохранить изменения', [
                    'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium text-lg',
                    'id' => 'submit-btn'
                ]) ?>

            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<!-- Стили -->
<style>
    /* Выбранная иконка */
    .icon-select.selected {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .icon-select.selected span {
        color: #dbeafe;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .grid-cols-2, .md\:grid-cols-6 {
            grid-template-columns: repeat(3, 1fr);
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Элементы DOM
        const nameInput = document.getElementById('category-name');
        const descriptionInput = document.getElementById('category-description');
        const iconInput = document.getElementById('category-icon');
        const minAgeInput = document.getElementById('min-age-input');
        const maxAgeInput = document.getElementById('max-age-input');
        const submitBtn = document.getElementById('submit-btn');
        const ageDetection = document.getElementById('age-detection');

        // Предварительный просмотр
        const previewName = document.getElementById('preview-name');
        const previewDescription = document.getElementById('preview-description');
        const previewIcon = document.getElementById('preview-icon');
        const previewAge = document.getElementById('preview-age');
        const ageRangeVisual = document.getElementById('age-range-visual');
        const ageRangeText = document.getElementById('age-range-text');

        // Оригинальные значения
        const originalValues = {
            name: nameInput ? nameInput.value : '',
            description: descriptionInput ? descriptionInput.value : '',
            icon: iconInput ? iconInput.value : '',
            minAge: minAgeInput ? minAgeInput.value : '',
            maxAge: maxAgeInput ? maxAgeInput.value : ''
        };

        // Обновление предварительного просмотра
        function updatePreview() {
            if (nameInput && previewName) {
                previewName.textContent = nameInput.value || originalValues.name;

                // Автоматическое определение возраста из названия
                const ageMatch = nameInput.value.match(/(\d+)[-\s](\d+)/);
                if (ageMatch) {
                    const min = parseInt(ageMatch[1]);
                    const max = parseInt(ageMatch[2]);

                    // Показываем детектор возраста
                    if (ageDetection) {
                        ageDetection.classList.remove('hidden');
                        document.getElementById('min-age').textContent = min;
                        document.getElementById('max-age').textContent = max;
                    }

                    // Обновляем preview
                    if (previewAge) {
                        previewAge.textContent = `${min}-${max} лет`;
                    }



                    // Заполняем отдельные поля если они есть
                    if (minAgeInput && maxAgeInput) {
                        minAgeInput.value = min;
                        maxAgeInput.value = max;
                        updateAgeVisualization();
                    }
                } else {
                    if (ageDetection) {
                        ageDetection.classList.add('hidden');
                    }

                }
            }

            if (descriptionInput && previewDescription) {
                previewDescription.textContent = descriptionInput.value || originalValues.description || 'Описание отсутствует';
                if (descriptionInput.value.length > 80) {
                    previewDescription.textContent = descriptionInput.value.substring(0, 80) + '...';
                }
            }
        }



        // Проверка изменений
        function hasChanges() {
            if (nameInput && nameInput.value !== originalValues.name) return true;
            if (descriptionInput && descriptionInput.value !== originalValues.description) return true;
            if (iconInput && iconInput.value !== originalValues.icon) return true;
            if (minAgeInput && minAgeInput.value !== originalValues.minAge) return true;
            if (maxAgeInput && maxAgeInput.value !== originalValues.maxAge) return true;
            return false;
        }

        // Обработчики событий
        if (nameInput) {
            nameInput.addEventListener('input', updatePreview);
            nameInput.addEventListener('input', function() {
                if (this.value !== originalValues.name) {
                    this.classList.add('border-blue-400', 'bg-blue-50');
                } else {
                    this.classList.remove('border-blue-400', 'bg-blue-50');
                }
            });
        }

        if (descriptionInput) {
            descriptionInput.addEventListener('input', updatePreview);
            descriptionInput.addEventListener('input', function() {
                if (this.value !== originalValues.description) {
                    this.classList.add('border-blue-400', 'bg-blue-50');
                } else {
                    this.classList.remove('border-blue-400', 'bg-blue-50');
                }
            });
        }

        if (minAgeInput) {
            minAgeInput.addEventListener('input', updateAgeVisualization);
            minAgeInput.addEventListener('input', function() {
                if (this.value !== originalValues.minAge) {
                    this.classList.add('border-blue-400', 'bg-blue-50');
                } else {
                    this.classList.remove('border-blue-400', 'bg-blue-50');
                }
            });
        }

        if (maxAgeInput) {
            maxAgeInput.addEventListener('input', updateAgeVisualization);
            maxAgeInput.addEventListener('input', function() {
                if (this.value !== originalValues.maxAge) {
                    this.classList.add('border-blue-400', 'bg-blue-50');
                } else {
                    this.classList.remove('border-blue-400', 'bg-blue-50');
                }
            });
        }

        // Выбор иконки
        const iconButtons = document.querySelectorAll('.icon-select');
        iconButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Сброс предыдущего выбора
                iconButtons.forEach(btn => btn.classList.remove('selected'));

                // Установка нового выбора
                this.classList.add('selected');
                const icon = this.getAttribute('data-icon');

                if (iconInput) {
                    iconInput.value = icon;
                    if (icon !== originalValues.icon) {
                        iconInput.classList.add('changed');
                    } else {
                        iconInput.classList.remove('changed');
                    }
                }

                if (previewIcon) {
                    previewIcon.textContent = icon;
                }
            });
        });





        // Инициализация предварительного просмотра
        updatePreview();
    });
</script>