<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>

<!-- Основной контент -->
<div id="application-edit" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Редактирование заявки</h2>
            <p class="text-gray-600 mt-2">
                ID: <span class="font-semibold">#<?= $model->id ?></span> |
                Участник: <span class="font-semibold"><?= Html::encode($model->user->surname . ' ' . $model->user->name) ?></span>
            </p>
        </div>
        <?= Html::a('Назад к просмотру', ['application-view', 'id' => $model->id], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная форма -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <h3 class="text-2xl font-bold text-gray-800 mb-6">✏️ Редактирование информации</h3>

            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'space-y-6'],
                'action' => ['admin/edit-application', 'id' => $model->id],
                'method' => 'post'
            ]); ?>

            <!-- Название работы -->
            <div>
                <?= $form->field($model, 'title', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Введите полное название конкурсной работы</div>
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors text-lg font-medium',
                    'placeholder' => 'Например: «Весенний вальс» или «Портрет осени»'
                ])->label('🏆 Название работы *') ?>
            </div>

            <!-- Статус -->
            <div>
                <?= $form->field($model, 'status', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Текущий статус: <span id="current-status-badge" class="font-semibold"></span></div>
                    '
                ])->dropDownList([
                    'new' => '🆕 Новая',
                    'accepted' => '✅ Принята',
                    'blocked' => '🚫 Заблокирована',
                ], [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                    'id' => 'status-select'
                ])->label('📊 Статус заявки *') ?>
            </div>

            <!-- Дополнительные поля (если есть в модели) -->
            <?php if (isset($model->institution)): ?>
                <div>
                    <?= $form->field($model, 'institution', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                    '
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'Например: Детская школа искусств №1'
                    ])->label('🏛️ Учебное заведение') ?>
                </div>
            <?php endif; ?>

            <?php if (isset($model->leader)): ?>
                <div>
                    <?= $form->field($model, 'leader', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                    '
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'ФИО руководителя'
                    ])->label('👨‍🏫 Руководитель') ?>
                </div>
            <?php endif; ?>

            <!-- Комментарий (если есть поле) -->
            <?php if (isset($model->comment)): ?>
                <div>
                    <?= $form->field($model, 'comment', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Внутренние заметки по заявке</div>
                    '
                    ])->textarea([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'rows' => 4,
                        'placeholder' => 'Заметки для других администраторов...'
                    ])->label('📝 Комментарий администратора') ?>
                </div>
            <?php endif; ?>

            <!-- Кнопки -->
            <div class="mt-8 flex space-x-4">
                <?= Html::submitButton('💾 Сохранить изменения', [
                    'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium text-lg'
                ]) ?>

                <?= Html::a('↩️ Отменить', ['application-view', 'id' => $model->id], [
                    'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 px-6 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>

        <!-- Боковая панель -->
        <div class="space-y-6">
            <!-- Информация о заявке -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h4 class="text-lg font-semibold text-gray-800 mb-4">📋 Информация</h4>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Конкурс:</span>
                        <span class="font-medium"><?= Html::encode($model->contest->title) ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Номинация:</span>
                        <span class="font-medium"><?= Html::encode($model->nomination->name) ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Возрастная категория:</span>
                        <span class="font-medium"><?= Html::encode($model->ageCategory->name) ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Дата создания:</span>
                        <span class="font-medium"><?= date('d.m.Y H:i', strtotime($model->created_at)) ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Последнее обновление:</span>
                        <span class="font-medium"><?= date('d.m.Y H:i', strtotime($model->updated_at)) ?></span>
                    </div>
                </div>
            </div>






        </div>
    </div>
</div>

<!-- Стили -->
<style>

    /* Кастомный селект */
    select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3E%3C/svg%3E");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Функция для отображения бейджа статуса
        function updateStatusBadge() {
            const select = document.getElementById('status-select');
            const badge = document.getElementById('current-status-badge');

            const statusConfig = {
                'new': ['🆕 Новая', 'bg-yellow-100 text-yellow-800'],
                'accepted': ['✅ Принята', 'bg-green-100 text-green-800'],
                'blocked': ['🚫 Заблокирована', 'bg-red-100 text-red-800']
            };

            const status = select.value;
            const [text, classes] = statusConfig[status] || ['❓ Неизвестно', 'bg-gray-100 text-gray-800'];

            badge.innerHTML = `<span class="px-2 py-1 rounded text-sm ${classes}">${text}</span>`;
        }

        // Инициализация бейджа
        const statusSelect = document.getElementById('status-select');
        if (statusSelect) {
            updateStatusBadge();
            statusSelect.addEventListener('change', updateStatusBadge);
        }

        // Подтверждение опасных изменений
        const statusChangeWarning = {
            'new': 'accepted',
            'accepted': 'blocked',
            'blocked': 'accepted'
        };

        const form = document.querySelector('form');
        if (form) {
            const originalStatus = '<?= $model->status ?>';

            form.addEventListener('submit', function(e) {
                const currentStatus = document.getElementById('status-select').value;

                // Проверка на изменение статуса
                if (currentStatus !== originalStatus) {
                    let message = '';

                    if (currentStatus === 'blocked' && originalStatus !== 'blocked') {
                        message = 'Вы собираетесь заблокировать заявку. Участник не сможет её просматривать. Продолжить?';
                    } else if (currentStatus === 'accepted' && originalStatus === 'blocked') {
                        message = 'Вы собираетесь разблокировать и принять заявку. Участник получит уведомление. Продолжить?';
                    } else if (currentStatus === 'new' && originalStatus === 'accepted') {
                        message = 'Вы собираетесь вернуть принятую заявку в статус "Новая". Это может сбить процесс оценки. Продолжить?';
                    }

                    if (message && !confirm(message)) {
                        e.preventDefault();
                        return false;
                    }
                }

                // Показать индикатор загрузки
                const submitBtn = this.querySelector('button[type="submit"]');
                if (submitBtn) {
                    const originalText = submitBtn.innerHTML;
                    submitBtn.innerHTML = '<span class="flex items-center justify-center"><svg class="animate-spin h-5 w-5 mr-2 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Сохранение...</span>';
                    submitBtn.disabled = true;

                    setTimeout(() => {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }, 3000);
                }
            });
        }

        // Подсветка измененных полей
        const inputs = form ? form.querySelectorAll('input, textarea, select') : [];
        inputs.forEach(input => {
            const originalValue = input.value;

            input.addEventListener('input', function() {
                if (this.value !== originalValue) {
                    this.classList.add('border-blue-400', 'bg-blue-50');
                } else {
                    this.classList.remove('border-blue-400', 'bg-blue-50');
                }
            });
        });
    });
</script>