<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
?>

<!-- Основной контент -->
<div id="applications-admin" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Управление заявками</h2>
    </div>

    <!-- Фильтры -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">🔍 Фильтры</h3>

        <?php $form = ActiveForm::begin([
            'method' => 'get',
            'action' => ['applications'],
            'options' => ['class' => 'space-y-6']
        ]); ?>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <!-- Фамилия -->
            <div>
                <?= $form->field($searchModel, 'surname', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Иванов'
                ])->label('Фамилия') ?>
            </div>

            <!-- Имя -->
            <div>
                <?= $form->field($searchModel, 'name', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Иван'
                ])->label('Имя') ?>
            </div>

            <!-- Статус -->
            <div>
                <?= $form->field($searchModel, 'status', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                    '
                ])->dropDownList([
                    'new' => '🆕 Новая',
                    'accepted' => '✅ Принята',
                    'blocked' => '🚫 Заблокирована',
                ], [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 appearance-none bg-white',
                    'prompt' => 'Все статусы'
                ])->label('Статус') ?>
            </div>

        </div>

        <div class="flex justify-between items-center pt-4 border-t border-gray-200">
            <div class="text-sm text-gray-600">
                Найдено: <span class="font-semibold"><?= $dataProvider->totalCount ?></span> заявок
            </div>
            <div class="flex space-x-3">
                <?= Html::submitButton('🔍 Применить фильтры', [
                    'class' => 'bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors'
                ]) ?>

                <?= Html::a('🗑️ Сбросить', ['applications'], [
                    'class' => 'border border-gray-300 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-50 transition-colors'
                ]) ?>
            </div>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

    <!-- Таблица заявок -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">Список заявок</h3>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">#</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Участник</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Конкурс</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Номинация</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Возраст</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Работа</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($dataProvider->getModels() as $index => $model): ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors">
                        <td class="py-4 text-gray-600"><?= $index + 1 + ($dataProvider->pagination->page * $dataProvider->pagination->pageSize) ?></td>

                        <!-- Участник -->
                        <td class="py-4">
                            <div class="font-medium text-gray-800"><?= Html::encode($model->user->surname . ' ' . $model->user->name) ?></div>
                            <div class="text-sm text-gray-500"><?= Html::encode($model->user->email) ?></div>
                        </td>

                        <!-- Конкурс -->
                        <td class="py-4 text-gray-800"><?= Html::encode($model->contest->title) ?></td>

                        <!-- Номинация -->
                        <td class="py-4">
                            <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm">
                                <?= Html::encode($model->nomination->name) ?>
                            </span>
                        </td>

                        <!-- Возрастная категория -->
                        <td class="py-4">
                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                <?= Html::encode($model->ageCategory->name) ?>
                            </span>
                        </td>

                        <!-- Название работы -->
                        <td class="py-4 text-gray-800"><?= Html::encode($model->title) ?></td>

                        <!-- Статус -->
                        <td class="py-4">
                            <?php
                            $statusConfig = [
                                'new' => ['bg-yellow-100 text-yellow-800', '🆕'],
                                'accepted' => ['bg-green-100 text-green-800', '✅'],
                                'blocked' => ['bg-red-100 text-red-800', '🚫'],
                            ];
                            $statusData = $statusConfig[$model->status] ?? ['bg-gray-100 text-gray-800', '❓'];
                            ?>
                            <span class="px-3 py-1 rounded-full text-sm font-medium <?= $statusData[0] ?>">
                                <?= $statusData[1] ?> <?= Yii::t('app', $model->status) ?>
                            </span>
                        </td>

                        <!-- Действия -->
                        <td class="py-4">
                            <div class="flex flex-wrap gap-2">
                                <?= Html::a('👁️', ['application-view', 'id' => $model->id], [
                                    'class' => 'text-blue-600 hover:text-blue-800 text-lg',
                                    'title' => 'Просмотр'
                                ]) ?>

                                <?= Html::a('✏️', ['edit-application', 'id' => $model->id], [
                                    'class' => 'text-green-600 hover:text-green-800 text-lg',
                                    'title' => 'Редактировать'
                                ]) ?>

                                <?php if ($model->status === 'blocked'): ?>
                                    <?= Html::a('✅', ['unblock-application', 'id' => $model->id], [
                                        'class' => 'text-green-600 hover:text-green-800 text-lg',
                                        'title' => 'Разблокировать',
                                        'data' => ['confirm' => 'Разблокировать заявку?']
                                    ]) ?>
                                <?php else: ?>
                                    <?= Html::a('🚫', ['block-application', 'id' => $model->id], [
                                        'class' => 'text-red-600 hover:text-red-800 text-lg',
                                        'title' => 'Блокировать',
                                        'data' => ['confirm' => 'Заблокировать заявку?']
                                    ]) ?>
                                <?php endif; ?>

                                <?= Html::a('🗑️', ['delete-application', 'id' => $model->id], [
                                    'class' => 'text-gray-600 hover:text-red-800 text-lg',
                                    'title' => 'Удалить',
                                    'data' => ['confirm' => 'Вы уверены, что хотите удалить заявку?']
                                ]) ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * $dataProvider->pagination->page + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> заявок
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['applications', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['applications', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['applications', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Стили -->
<style>


    /* Кастомный селект */
    select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3E%3C/svg%3E");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-4 {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 768px) {
        .grid-cols-4, .grid-cols-2 {
            grid-template-columns: 1fr;
        }

        table {
            min-width: 1000px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .flex.space-x-2 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .flex.space-x-3 {
            flex-direction: column;
            gap: 0.5rem;
        }

        .flex.space-x-3 > * {
            width: 100%;
        }
    }
</style>

<script>
    // Быстрые кнопки фильтров
    document.addEventListener('DOMContentLoaded', function() {
        const filterButtons = document.querySelectorAll('.flex.space-x-2 button');
        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                const filterType = this.textContent.trim();

                // Сбрасываем активный класс у всех кнопок
                filterButtons.forEach(btn => {
                    btn.classList.remove('bg-blue-600', 'text-white');
                    btn.classList.add('border', 'border-gray-300', 'text-gray-700');
                });

                // Активируем текущую кнопку
                this.classList.remove('border', 'border-gray-300', 'text-gray-700');
                this.classList.add('bg-blue-600', 'text-white');

                // Применяем фильтр
                const statusMap = {
                    'Все': '',
                    'Новые': 'new',
                    'Принятые': 'accepted',
                    'Заблокированные': 'blocked'
                };

                if (statusMap[filterType] !== undefined) {
                    const statusSelect = document.querySelector('#applicationsearch-status');
                    if (statusSelect) {
                        statusSelect.value = statusMap[filterType];
                        // Можно автоматически отправлять форму
                        // document.querySelector('form').submit();
                    }
                }
            });
        });

        // Показ количества заявок по статусам
        updateStatusCounts();

        function updateStatusCounts() {
            // Здесь можно добавить AJAX запрос для получения статистики
            // пока что просто обновим текст на кнопках
            const totalCount = <?= $dataProvider->totalCount ?>;
            const totalButton = document.querySelector('.flex.space-x-2 button:first-child');
            if (totalButton && totalButton.textContent.includes('Все')) {
                totalButton.textContent = `Все (${totalCount})`;
            }
        }
    });
</script>