<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;

/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $stats array */
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Управление конкурсами</h2>

    <div class="flex items-center space-x-4">
        <?= Html::a('← Назад в админку', ['admin/index'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>
</div>

<!-- Статистика конкурсов -->
<?php if (isset($stats)): ?>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <!-- Все конкурсы -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-blue-600">🏆</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['total'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Всего конкурсов</p>
                </div>
            </div>
        </div>

        <!-- Активные конкурсы -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-green-600">✅</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['active'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Активных</p>
                </div>
            </div>
        </div>

        <!-- Предстоящие -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-yellow-600">⏳</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['upcoming'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Скоро начнутся</p>
                </div>
            </div>
        </div>

        <!-- Завершённые -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-gray-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-gray-600">⌛</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['completed'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Завершённых</p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>


<!-- Если нет конкурсов -->
<?php if ($dataProvider->getTotalCount() == 0): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span class="text-3xl text-gray-400">🏆</span>
        </div>
        <h3 class="text-xl font-semibold text-gray-800 mb-2">Конкурсов пока нет</h3>
        <p class="text-gray-600 mb-6">Создайте первый конкурс для начала работы</p>

        <?= Html::a('➕ Создать первый конкурс', ['contest-create'], [
            'class' => 'inline-block bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 transition-colors font-medium'
        ]) ?>
    </div>
<?php else: ?>

    <!-- Таблица конкурсов в стиле дизайн-проекта -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <!-- Заголовок таблицы -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-2xl font-bold text-gray-800">Список конкурсов</h3>
                <p class="text-sm text-gray-600">
                    Найдено: <span class="font-bold text-gray-800"><?= $dataProvider->getTotalCount() ?></span>
                    конкурсов
                </p>
            </div>
        </div>

        <!-- Кастомная таблица -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="bg-gray-50">
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">№</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Название</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Даты проведения</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Заявок</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                <?php
                $models = $dataProvider->getModels();
                $i = 1;
                foreach ($models as $model):
                    $now = time();
                    $start = strtotime($model->start_date);
                    $end = strtotime($model->end_date);

                    // Определение статуса
                    $status = '';
                    $statusColor = '';
                    $statusText = '';


                    // Количество заявок
                    $applicationCount = $model->getApplications()->count() ?? 0;
                    ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="py-4 px-6 text-gray-600"><?= $i++ ?></td>

                        <td class="py-4 px-6">
                            <div class="font-medium text-gray-800"><?= Html::encode($model->title) ?></div>
                            <?php if ($model->description): ?>
                                <div class="text-sm text-gray-600 mt-1"><?= Html::encode(mb_substr($model->description, 0, 80)) ?>
                                    ...
                                </div>
                            <?php endif; ?>
                        </td>


                        <td class="py-4 px-6">
                            <div class="text-gray-800">
                                <?= date('d.m.Y', $start) ?> — <?= date('d.m.Y', $end) ?>
                            </div>
                            <div class="text-xs text-gray-500">
                                <?php
                                if ($status == 'active') {
                                    $daysLeft = ceil(($end - $now) / (60 * 60 * 24));
                                    echo "Осталось {$daysLeft} дней";
                                } elseif ($status == 'upcoming') {
                                    $daysLeft = ceil(($start - $now) / (60 * 60 * 24));
                                    echo "Начнётся через {$daysLeft} дней";
                                }
                                ?>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                            <div class="">
                                <span class="text-gray-800">
                                    <span class="text-lg font-bold"><?= $applicationCount ?></span>
                                    <span class="text-xs font-bold">заявок</span>
                                </span>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                            <div class="flex space-x-3">
                                <?= Html::a('Смотреть', ['contest-view', 'id' => $model->id], [
                                    'class' => 'text-blue-600 hover:text-blue-800 font-medium'
                                ]) ?>
                                <?= Html::a('Редактировать', ['contest-update', 'id' => $model->id], [
                                    'class' => 'text-blue-600 hover:text-blue-800 font-medium'
                                ]) ?>

                                <?= Html::beginForm(['contest-delete', 'id' => $model->id], 'post', [
                                    'style' => 'display: inline;',
                                    'class' => 'delete-form'
                                ]) ?>
                                <?= Html::submitButton('Удалить', [
                                    'class' => 'text-red-600 hover:text-red-800 font-medium bg-transparent border-none p-0 cursor-pointer',
                                    'data' => [
                                        'confirm' => 'Вы уверены, что хотите удалить этот конкурс?',
                                    ]
                                ]) ?>
                                <?= Html::endForm() ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php
        $pagination = $dataProvider->getPagination();
        if ($pagination && $pagination->pageCount > 1): ?>
            <div class="p-6 border-t border-gray-200">
                <div class="flex justify-between items-center">
                    <div class="text-sm text-gray-600">
                        Показано <?= $pagination->offset + 1 ?>
                        - <?= min($pagination->offset + $pagination->limit, $pagination->totalCount) ?>
                        из <?= $pagination->totalCount ?> конкурсов
                    </div>
                    <nav class="inline-flex rounded-md shadow">
                        <?php if ($pagination->page > 0): ?>
                            <?= Html::a('← Назад', array_merge(['contests/index'], $pagination->params, ['page' => $pagination->page]), [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-l-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>

                        <?php for ($i = 1; $i <= $pagination->pageCount; $i++): ?>
                            <?= Html::a($i, array_merge(['contests/index'], $pagination->params, ['page' => $i]), [
                                'class' => 'px-4 py-2 border-t border-b border-gray-300 ' .
                                    ($i == $pagination->page + 1 ? 'bg-blue-50 text-blue-600 border-blue-500' : 'hover:bg-gray-50')
                            ]) ?>
                        <?php endfor; ?>

                        <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                            <?= Html::a('Вперед →', array_merge(['contests/index'], $pagination->params, ['page' => $pagination->page + 2]), [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-r-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
    </div>


<?php endif; ?>

