<?php
use yii\helpers\Html;
use yii\grid\GridView;
?>

<!-- Основной контент -->
<div id="evaluations-index" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">🎯 Оценки заявок</h2>

    </div>

    <!-- Фильтры и статистика -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">🔍 Фильтры и общая статистика</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
            <!-- Статистика -->
            <div class="bg-blue-50 border border-blue-100 rounded-lg p-4">
                <div class="text-sm text-blue-600 mb-1">Всего оценок</div>
                <div class="text-2xl font-bold text-blue-800"><?= $dataProvider->totalCount ?></div>
            </div>

            <div class="bg-green-50 border border-green-100 rounded-lg p-4">
                <div class="text-sm text-green-600 mb-1">Завершённые</div>
                <div class="text-2xl font-bold text-green-800">
                    <?= $completedCount ?? count(array_filter($dataProvider->getModels(), fn($m) => $m->status === 'completed')) ?>
                </div>
            </div>

            <div class="bg-yellow-50 border border-yellow-100 rounded-lg p-4">
                <div class="text-sm text-yellow-600 mb-1">Ожидают оценки</div>
                <div class="text-2xl font-bold text-yellow-800">
                    <?= $draftCount ?? count(array_filter($dataProvider->getModels(), fn($m) => $m->status === 'draft')) ?>
                </div>
            </div>

            <div class="bg-purple-50 border border-purple-100 rounded-lg p-4">
                <div class="text-sm text-purple-600 mb-1">Средний балл</div>
                <div class="text-2xl font-bold text-purple-800">
                    <?= number_format($averageScore ?? array_reduce($dataProvider->getModels(), fn($carry, $m) => $carry + $m->getAverage(), 0) / max(1, $dataProvider->totalCount), 2) ?>
                </div>
            </div>
        </div>

    </div>

    <!-- Таблица оценок -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">📋 Детализация оценок</h3>
            <div class="text-sm text-gray-600">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">#</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Заявка / Участник</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Эксперт</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Критерии</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Результаты</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($dataProvider->getModels() as $index => $model): ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors" data-status="<?= $model->status ?>">
                        <td class="py-4 text-gray-600"><?= $index + 1 + ($dataProvider->pagination->page * $dataProvider->pagination->pageSize) ?></td>

                        <!-- Заявка и участник -->
                        <td class="py-4">
                            <div class="font-medium text-gray-800"><?= Html::encode($model->application->title) ?></div>
                            <div class="text-sm text-gray-500">
                                👤 <?= Html::encode($model->application->user->surname . ' ' . $model->application->user->name) ?>
                            </div>
                            <div class="text-xs text-gray-400 mt-1">
                                🎯 <?= Html::encode($model->application->nomination->name) ?>
                            </div>
                        </td>

                        <!-- Эксперт -->
                        <td class="py-4">
                            <div class="font-medium text-gray-800">
                                👨‍⚖️ <?= Html::encode($model->expert->surname . ' ' . $model->expert->name) ?>
                            </div>
                            <div class="text-sm text-gray-500">
                                <?= Html::encode($model->expert->email) ?>
                            </div>
                        </td>

                        <!-- Критерии оценки -->
                        <td class="py-4">
                            <div class="space-y-2">
                                <div class="flex items-center text-sm">
                                    <span class="text-gray-600 w-32">Мастерство:</span>
                                    <div class="w-8"></div> <!-- Отступ 32px (w-8 = 2rem) -->
                                    <span class="font-bold <?= $model->mastery >= 8 ? 'text-green-600' : ($model->mastery >= 6 ? 'text-yellow-600' : 'text-red-600') ?>">
                <?= $model->mastery ?>/10
            </span>
                                </div>
                                <div class="flex items-center text-sm">
                                    <span class="text-gray-600 w-32">Артистизм:</span>
                                    <div class="w-8"></div>
                                    <span class="font-bold <?= $model->artistry >= 8 ? 'text-green-600' : ($model->artistry >= 6 ? 'text-yellow-600' : 'text-red-600') ?>">
                <?= $model->artistry ?>/10
            </span>
                                </div>
                                <div class="flex items-center text-sm">
                                    <span class="text-gray-600 w-32">Сценическая культура:</span>
                                    <div class="w-8"></div>
                                    <span class="font-bold <?= $model->stage_culture >= 8 ? 'text-green-600' : ($model->stage_culture >= 6 ? 'text-yellow-600' : 'text-red-600') ?>">
                <?= $model->stage_culture ?>/10
            </span>
                                </div>
                            </div>
                        </td>

                        <!-- Итоговые результаты -->
                        <td class="py-4">
                            <div class="space-y-2">
                                <div class="flex items-center">
                                    <span class="text-gray-600 mr-2">Сумма:</span>
                                    <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-bold">
                                        <?= $model->getTotal() ?>/30
                                    </span>
                                </div>
                                <div class="flex items-center">
                                    <span class="text-gray-600 mr-2">Среднее:</span>
                                    <span class="px-3 py-1 <?= $model->getAverage() >= 8 ? 'bg-green-100 text-green-800' : ($model->getAverage() >= 6 ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') ?> rounded-full text-sm font-bold">
                                        <?= number_format($model->getAverage(), 1) ?>
                                    </span>
                                </div>
                                <div class="text-xs text-gray-500">
                                    <?php $percentage = ($model->getTotal() / 30) * 100; ?>
                                    <div class="w-full bg-gray-200 rounded-full h-1.5 mt-1">
                                        <div class="bg-blue-600 h-1.5 rounded-full" style="width: <?= $percentage ?>%"></div>
                                    </div>
                                    <div class="text-right"><?= number_format($percentage, 1) ?>%</div>
                                </div>
                            </div>
                        </td>

                        <!-- Статус -->
                        <td class="py-4">
                            <?php if ($model->status === 'completed'): ?>
                                <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">
                                    ✅ Завершена
                                </span>
                                <div class="text-xs text-gray-500 mt-1">
                                    <?= date('d.m.Y', strtotime($model->updated_at)) ?>
                                </div>
                            <?php else: ?>
                                <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">
                                    ⏳ Ожидает оценки
                                </span>
                                <div class="text-xs text-gray-500 mt-1">
                                    Назначена: <?= date('d.m.Y', strtotime($model->created_at)) ?>
                                </div>
                            <?php endif; ?>
                        </td>

                        <!-- Действия -->
                        <td class="py-4">
                            <div class="flex space-x-2">
                                <?= Html::a('Сбросить', ['reset-evaluation', 'id' => $model->id], [
                                'class' => 'text-red-600',
                                'data' => ['confirm' => 'Сбросить статус оценки?']
                                    ]);?>

                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * $dataProvider->pagination->page + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> оценок
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['evaluations', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['evaluations', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['evaluations', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Стили -->
<style>
    /* Адаптивность */
    @media (max-width: 768px) {
        table {
            min-width: 1200px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .grid-cols-4 {
            grid-template-columns: repeat(2, 1fr);
        }

        .flex.space-x-2 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            width: 100%;
            text-align: center;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Фильтрация по статусу
        const filterButtons = document.querySelectorAll('button[data-filter]');
        const tableRows = document.querySelectorAll('tbody tr');

        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                const filter = this.getAttribute('data-filter');

                // Обновляем активную кнопку
                filterButtons.forEach(btn => {
                    btn.classList.remove('bg-blue-600', 'text-white');
                    btn.classList.add('border', 'border-gray-300', 'text-gray-700');
                });
                this.classList.remove('border', 'border-gray-300', 'text-gray-700');
                this.classList.add('bg-blue-600', 'text-white');

                // Фильтруем строки
                tableRows.forEach(row => {
                    const status = row.getAttribute('data-status');
                    const average = parseFloat(row.querySelector('.bg-green-100, .bg-yellow-100, .bg-red-100')?.textContent || 0);

                    let show = true;

                    switch(filter) {
                        case 'completed':
                            show = status === 'completed';
                            break;
                        case 'draft':
                            show = status === 'draft';
                            break;
                        case 'top':
                            show = average >= 9.0; // 90% от 10
                            break;
                        default:
                            show = true;
                    }

                    row.style.display = show ? '' : 'none';
                });
            });
        });

        // Подсветка топовых оценок
        tableRows.forEach(row => {
            const averageCell = row.querySelector('.bg-green-100, .bg-yellow-100, .bg-red-100');
            if (averageCell) {
                const average = parseFloat(averageCell.textContent);
                if (average >= 9.0) {
                    row.classList.add('bg-gradient-to-r', 'from-yellow-50', 'to-transparent');
                    const medal = document.createElement('span');
                    medal.className = 'ml-2 text-yellow-500';
                    medal.textContent = '🏆';
                    averageCell.appendChild(medal);
                }
            }

            // Подсказка для комментариев
            const commentIcon = row.querySelector('.text-gray-400[title]');
            if (commentIcon) {
                commentIcon.addEventListener('mouseenter', function() {
                    const tooltip = document.createElement('div');
                    tooltip.className = 'absolute z-10 bg-gray-900 text-white text-sm rounded p-2 max-w-xs';
                    tooltip.textContent = this.getAttribute('title').replace('Есть комментарий: ', '');
                    this.appendChild(tooltip);
                });

                commentIcon.addEventListener('mouseleave', function() {
                    const tooltip = this.querySelector('div');
                    if (tooltip) tooltip.remove();
                });
            }
        });

        // Экспорт данных
        const exportBtn = document.querySelector('a[href*="export-evaluations"]');
        if (exportBtn) {
            exportBtn.addEventListener('click', function(e) {
                e.preventDefault();

                if (confirm('Экспортировать все оценки в Excel? Будут включены все фильтры.')) {
                    const spinner = document.createElement('span');
                    spinner.className = 'animate-spin ml-2';
                    spinner.innerHTML = '⌛';
                    this.appendChild(spinner);

                    setTimeout(() => {
                        window.location.href = this.href;
                    }, 1000);
                }
            });
        }
    });
</script>