<?php
use yii\helpers\Html;
?>

<!-- Основной контент -->
<div id="nominations-index" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">🏆 Управление номинациями</h2>
        <?= Html::a('➕ Создать номинацию', ['nomination-create'], [
            'class' => 'bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors flex items-center'
        ]) ?>
    </div>





    <!-- Таблица номинаций -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">Список номинаций</h3>

        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">#</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Номинация</th>

                    <th class="text-left py-3 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($dataProvider->getModels() as $index => $nomination): ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors">
                        <td class="py-4 text-gray-600"><?= $index + 1 + ($dataProvider->pagination->page * $dataProvider->pagination->pageSize) ?></td>

                        <!-- Название номинации -->
                        <td class="py-4">
                            <div class="flex items-center">
                                <div class="p-2 bg-blue-100 rounded-lg mr-3">
                                    <span class="text-blue-600">
                                        <?php
                                        $icons = ['🎭', '🎨', '🎤', '💃', '🎼', '🎬', '📸', '✍️'];
                                        echo $icons[$nomination->id % count($icons)] ?? '🏆';
                                        ?>
                                    </span>
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-800 text-lg"><?= Html::encode($nomination->name) ?></h4>
                                    <div class="text-sm text-gray-500">
                                        ID: #<?= $nomination->id ?>
                                    </div>
                                </div>
                            </div>
                        </td>


                        <!-- Действия -->
                        <td class="py-4">
                            <div class="flex space-x-3">


                                <?= Html::a('✏️', ['nomination-update', 'id' => $nomination->id], [
                                    'class' => 'text-green-600 hover:text-green-800 text-lg',
                                    'title' => 'Редактировать'
                                ]) ?>



                                <?= Html::a('🗑️', ['nomination-delete', 'id' => $nomination->id], [
                                    'class' => 'text-red-600 hover:text-red-800 text-lg',
                                    'title' => 'Удалить',
                                    'data' => [
                                        'confirm' => 'Вы уверены, что хотите удалить номинацию "' . Html::encode($nomination->name) . '"? Все связанные заявки могут быть затронуты.'
                                    ]
                                ]) ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * $dataProvider->pagination->page + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> номинаций
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['index', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['index', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['index', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Пустое состояние -->
    <?php if ($dataProvider->totalCount == 0): ?>
        <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-8 text-center mt-6">
            <div class="text-6xl mb-4">🏆</div>
            <h3 class="text-2xl font-bold text-yellow-800 mb-2">Номинаций пока нет</h3>
            <p class="text-yellow-600 mb-6">Создайте первую номинацию, чтобы начать принимать заявки от участников</p>
            <?= Html::a('➕ Создать первую номинацию', ['nomination-create'], [
                'class' => 'bg-yellow-500 text-white px-6 py-3 rounded-lg hover:bg-yellow-600 transition-colors inline-flex items-center'
            ]) ?>
        </div>
    <?php endif; ?>
</div>

<!-- Стили -->
<style>


    /* Адаптивность */
    @media (max-width: 768px) {
        table {
            min-width: 800px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .grid-cols-3 {
            grid-template-columns: 1fr;
        }

        .flex.space-x-2, .flex.space-x-3 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Фильтрация
        const filterAll = document.getElementById('filter-all');
        const filterPopular = document.getElementById('filter-popular');
        const filterRecent = document.getElementById('filter-recent');
        const tableRows = document.querySelectorAll('tbody tr');

        function resetFilters() {
            [filterAll, filterPopular, filterRecent].forEach(btn => {
                btn.classList.remove('bg-blue-600', 'text-white');
                btn.classList.add('border', 'border-gray-300', 'text-gray-700');
            });
        }

        filterAll.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => row.style.display = '');
        });

        filterPopular.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => {
                const count = parseInt(row.querySelector('.text-blue-600').textContent) || 0;
                row.style.display = count >= 5 ? '' : 'none';
            });
        });

        filterRecent.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            const oneMonthAgo = new Date();
            oneMonthAgo.setMonth(oneMonthAgo.getMonth() - 1);

            tableRows.forEach(row => {
                const dateText = row.querySelector('.text-gray-400').textContent.replace('Создана: ', '');
                const [day, month, year] = dateText.split('.');
                const rowDate = new Date(`${year}-${month}-${day}`);
                row.style.display = rowDate >= oneMonthAgo ? '' : 'none';
            });
        });

        // Подтверждение удаления
        const deleteLinks = document.querySelectorAll('a[data-confirm]');
        deleteLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm(this.getAttribute('data-confirm'))) {
                    e.preventDefault();
                    return false;
                }

                // Показать индикатор загрузки
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center"><svg class="animate-spin h-4 w-4 mr-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Удаление...</span>';
                this.classList.add('opacity-50');

                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('opacity-50');
                }, 2000);
            });
        });

        // Подсветка популярных номинаций
        tableRows.forEach(row => {
            const count = parseInt(row.querySelector('.text-blue-600').textContent) || 0;
            if (count >= 10) {
                row.classList.add('bg-gradient-to-r', 'from-yellow-50', 'to-transparent');
                const popularBadge = document.createElement('span');
                popularBadge.className = 'ml-2 text-xs bg-yellow-500 text-white px-2 py-1 rounded-full';
                popularBadge.textContent = '🔥 Популярная';
                row.querySelector('.font-bold.text-gray-800').appendChild(popularBadge);
            }
        });
    });
</script>