<?php
use yii\helpers\Html;
use yii\grid\GridView;
?>

<!-- Основной контент -->
<div id="notifications-index" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">🔔 Уведомления</h2>
        <?= Html::a('➕ Создать уведомление', ['create-notification'], [
            'class' => 'bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors flex items-center'
        ]) ?>
    </div>





    <!-- Таблица уведомлений -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">📋 Список уведомлений</h3>

        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">#</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Уведомление</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Получатель</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Дата</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($dataProvider->getModels() as $index => $notification): ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors"
                        data-is-read="<?= $notification->is_read ? 'read' : 'unread' ?>"
                        data-date="<?= date('Y-m-d', strtotime($notification->created_at)) ?>">
                        <td class="py-4 text-gray-600"><?= $index + 1 + ($dataProvider->pagination->page * $dataProvider->pagination->pageSize) ?></td>

                        <!-- Уведомление -->
                        <td class="py-4">
                            <div class="max-w-md">
                                <h4 class="font-bold text-gray-800 mb-1"><?= Html::encode($notification->title) ?></h4>
                                <p class="text-sm text-gray-600 truncate" title="<?= Html::encode($notification->message) ?>">
                                    <?= Html::encode(mb_strlen($notification->message) > 80 ? mb_substr($notification->message, 0, 80) . '...' : $notification->message) ?>
                                </p>
                            </div>
                        </td>

                        <!-- Получатель -->
                        <td class="py-4">
                            <div class="flex items-center">
                                <div class="p-2 bg-blue-100 rounded-lg mr-3">
                                    <span class="text-blue-600">👤</span>
                                </div>
                                <div>
                                    <div class="font-medium text-gray-800"><?= Html::encode($notification->user->surname . ' ' . $notification->user->name) ?></div>
                                    <div class="text-sm text-gray-500">
                                        <?= Html::encode($notification->user->email) ?>
                                    </div>
                                </div>
                            </div>
                        </td>

                        <!-- Статус -->
                        <td class="py-4">
                            <?php if ($notification->is_read): ?>
                                <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">
            ✅ Прочитано
        </span>

                            <?php else: ?>
                                <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">
            📬 Не прочитано
        </span>
                            <?php endif; ?>
                        </td>

                        <!-- Дата -->
                        <td class="py-4">
                            <div class="space-y-1">
                                <div class="font-medium text-gray-800">
                                    <?= date('d.m.Y', strtotime($notification->created_at)) ?>
                                </div>
                                <div class="text-sm text-gray-500">
                                    <?= date('H:i', strtotime($notification->created_at)) ?>
                                </div>
                                <div class="text-xs text-gray-400">
                                    <?php
                                    $daysAgo = floor((time() - strtotime($notification->created_at)) / (60 * 60 * 24));
                                    if ($daysAgo == 0) echo 'Сегодня';
                                    elseif ($daysAgo == 1) echo 'Вчера';
                                    elseif ($daysAgo < 7) echo $daysAgo . ' дня назад';
                                    elseif ($daysAgo < 30) echo floor($daysAgo / 7) . ' недели назад';
                                    else echo floor($daysAgo / 30) . ' месяца назад';
                                    ?>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * $dataProvider->pagination->page + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> уведомлений
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['index', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['index', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['index', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Пустое состояние -->
    <?php if ($dataProvider->totalCount == 0): ?>
        <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-8 text-center mt-6">
            <div class="text-6xl mb-4">🔔</div>
            <h3 class="text-2xl font-bold text-yellow-800 mb-2">Уведомлений пока нет</h3>
            <p class="text-yellow-600 mb-6">Создайте первое уведомление для пользователей</p>
            <?= Html::a('➕ Создать первое уведомление', ['create-notification'], [
                'class' => 'bg-yellow-500 text-white px-6 py-3 rounded-lg hover:bg-yellow-600 transition-colors inline-flex items-center'
            ]) ?>
        </div>
    <?php endif; ?>
</div>

<!-- Стили -->
<style>


    /* Подсветка непрочитанных уведомлений */
    tr[data-is-read="unread"] {
        background-color: #fefce8;
        border-left: 4px solid #fbbf24;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        table {
            min-width: 1000px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .grid-cols-4 {
            grid-template-columns: repeat(2, 1fr);
        }

        .flex.space-x-2, .flex.space-x-3 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Фильтрация
        const filterAll = document.getElementById('filter-all');
        const filterUnread = document.getElementById('filter-unread');
        const filterRead = document.getElementById('filter-read');
        const filterToday = document.getElementById('filter-today');
        const tableRows = document.querySelectorAll('tbody tr');

        function resetFilters() {
            [filterAll, filterUnread, filterRead, filterToday].forEach(btn => {
                btn.classList.remove('bg-blue-600', 'text-white');
                btn.classList.add('border', 'border-gray-300', 'text-gray-700');
            });
        }

        filterAll.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => row.style.display = '');
        });

        filterUnread.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => {
                const isRead = row.getAttribute('data-is-read');
                row.style.display = isRead === 'unread' ? '' : 'none';
            });
        });

        filterRead.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => {
                const isRead = row.getAttribute('data-is-read');
                row.style.display = isRead === 'read' ? '' : 'none';
            });
        });

        filterToday.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            const today = new Date().toISOString().split('T')[0];

            tableRows.forEach(row => {
                const date = row.getAttribute('data-date');
                row.style.display = date === today ? '' : 'none';
            });
        });

        // Подтверждение действий
        const deleteLinks = document.querySelectorAll('a[data-confirm]');
        deleteLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm(this.getAttribute('data-confirm'))) {
                    e.preventDefault();
                    return false;
                }

                // Показать индикатор загрузки
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center"><svg class="animate-spin h-4 w-4 mr-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Удаление...</span>';
                this.classList.add('opacity-50');

                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('opacity-50');
                }, 2000);
            });
        });

        // Подсказки для длинных сообщений
        const messageCells = document.querySelectorAll('.text-gray-600.truncate');
        messageCells.forEach(cell => {
            cell.addEventListener('mouseenter', function() {
                const tooltip = document.createElement('div');
                tooltip.className = 'fixed z-50 bg-gray-900 text-white text-sm rounded p-3 max-w-sm';
                tooltip.textContent = this.getAttribute('title');
                tooltip.style.left = (this.getBoundingClientRect().left + window.scrollX) + 'px';
                tooltip.style.top = (this.getBoundingClientRect().bottom + window.scrollY + 5) + 'px';
                tooltip.id = 'message-tooltip';
                document.body.appendChild(tooltip);
            });

            cell.addEventListener('mouseleave', function() {
                const tooltip = document.getElementById('message-tooltip');
                if (tooltip) tooltip.remove();
            });
        });

        // Быстрое изменение статуса
        const statusButtons = document.querySelectorAll('a[title*="Отметить"]');
        statusButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();

                const url = this.href;
                const row = this.closest('tr');

                // Показать индикатор
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center"><svg class="animate-spin h-4 w-4 mr-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Обновление...</span>';

                // Имитация AJAX запроса (в реальности нужно сделать fetch)
                setTimeout(() => {
                    this.innerHTML = originalHTML;

                    // Обновляем статус в таблице
                    const isCurrentlyRead = row.getAttribute('data-is-read') === 'read';
                    row.setAttribute('data-is-read', isCurrentlyRead ? 'unread' : 'read');

                    const statusCell = row.querySelector('.px-3.py-1');
                    const statusText = row.querySelector('.font-medium');
                    const dateText = row.querySelector('.text-xs.text-gray-500');

                    if (isCurrentlyRead) {
                        // Меняем на "не прочитано"
                        statusCell.className = 'px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium';
                        statusCell.textContent = '📬 Не прочитано';
                        statusText.textContent = '📬 Не прочитано';
                        dateText.innerHTML = `Отправлено: ${new Date().toLocaleDateString('ru-RU')}`;
                    } else {
                        // Меняем на "прочитано"
                        statusCell.className = 'px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium';
                        statusCell.textContent = '✅ Прочитано';
                        statusText.textContent = '✅ Прочитано';
                        dateText.innerHTML = `${new Date().toLocaleDateString('ru-RU')} ${new Date().toLocaleTimeString('ru-RU', {hour: '2-digit', minute: '2-digit'})}`;
                    }

                    // Обновляем иконку действия
                    const actionIcon = this.querySelector('span')?.textContent || this.textContent;
                    if (actionIcon.includes('✅')) {
                        this.title = 'Отметить как непрочитанное';
                        this.querySelector('span').textContent = '📬';
                    } else {
                        this.title = 'Отметить как прочитанное';
                        this.querySelector('span').textContent = '✅';
                    }

                }, 1000);
            });
        });
    });
</script>