<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>

<!-- Основной контент -->
<div id="user-create" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Создание пользователя</h2>
        <?= Html::a('Назад к списку', ['index'], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="bg-white rounded-xl shadow-md p-6 max-w-2xl">
        <?php $form = ActiveForm::begin([
            'options' => ['class' => 'space-y-6']
        ]); ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Фамилия -->
            <div>
                <?= $form->field($model, 'surname', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Введите фамилию пользователя</div>
                    ',
                    'options' => ['class' => 'form-group']
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'Иванов'
                ]) ?>
            </div>

            <!-- Имя -->
            <div>
                <?= $form->field($model, 'name', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Введите имя пользователя</div>
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'Иван'
                ]) ?>
            </div>
        </div>

        <!-- Отчество -->
        <div>
            <?= $form->field($model, 'patronymic', [
                'template' => '
                    <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                    {input}
                    {error}
                    <div class="text-sm text-gray-500 mt-1">Введите отчество (необязательно)</div>
                '
            ])->textInput([
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                'placeholder' => 'Иванович'
            ]) ?>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Логин -->
            <div>
                <?= $form->field($model, 'login', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Уникальный логин для входа</div>
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'ivanov'
                ]) ?>
            </div>

            <!-- Email -->
            <div>
                <?= $form->field($model, 'email', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Действующий email адрес</div>
                    '
                ])->input('email', [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'ivanov@example.com'
                ]) ?>
            </div>
        </div>

        <!-- Пароль -->
        <div>
            <?= $form->field($model, 'password_hash', [
                'template' => '
                    <label class="block text-sm font-medium text-gray-700 mb-2">Пароль *</label>
                    {input}
                    {error}
                    <div class="text-sm text-gray-500 mt-1">Минимум 8 символов</div>
                '
            ])->passwordInput([
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                'placeholder' => '••••••••'
            ]) ?>
        </div>

        <!-- Роль -->
        <div>
            <?= $form->field($model, 'role', [
                'template' => '
                    <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                    {input}
                    {error}
                    <div class="text-sm text-gray-500 mt-1">Выберите права доступа</div>
                '
            ])->dropDownList([
                \app\models\User::ROLE_PARTICIPANT => '👤 Участник',
                \app\models\User::ROLE_EXPERT => '⭐ Эксперт',
                \app\models\User::ROLE_ADMIN => '👑 Администратор',
            ], [
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                'prompt' => 'Выберите роль...'
            ]) ?>
        </div>

        <!-- Кнопки -->
        <div class="mt-8 flex space-x-4">
            <?= Html::submitButton('Создать пользователя', [
                'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium text-lg'
            ]) ?>

            <?= Html::a('Отмена', ['index'], [
                'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 px-6 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

</div>

<!-- Дополнительные стили -->
<style>

    /* Кастомный селект */
    select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3E%3C/svg%3E");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .grid-cols-2 {
            grid-template-columns: 1fr;
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    // Валидация в реальном времени
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        if (form) {
            const inputs = form.querySelectorAll('input, select');

            inputs.forEach(input => {
                input.addEventListener('blur', function() {
                    if (this.value.trim() === '') {
                        this.classList.add('border-red-300', 'bg-red-50');
                    } else {
                        this.classList.remove('border-red-300', 'bg-red-50');
                    }
                });

                input.addEventListener('input', function() {
                    this.classList.remove('border-red-300', 'bg-red-50');
                });
            });

            // Валидация пароля
            const passwordInput = form.querySelector('input[type="password"]');
            if (passwordInput) {
                passwordInput.addEventListener('input', function() {
                    if (this.value.length < 8 && this.value.length > 0) {
                        this.classList.add('border-yellow-300', 'bg-yellow-50');
                    } else {
                        this.classList.remove('border-yellow-300', 'bg-yellow-50');
                    }
                });
            }
        }
    });
</script>