<?php
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $model app\models\Application */
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Заявка: <?= Html::encode($model->title) ?></h2>

    <div class="flex items-center space-x-4">
        <?php
        // Статус с цветом
        $statusColor = 'bg-gray-100 text-gray-800';
        if ($model->status == 'approved') $statusColor = 'bg-green-100 text-green-800';
        elseif ($model->status == 'pending') $statusColor = 'bg-yellow-100 text-yellow-800';
        elseif ($model->status == 'rejected') $statusColor = 'bg-red-100 text-red-800';
        elseif ($model->status == 'active') $statusColor = 'bg-blue-100 text-blue-800';
        ?>

        <span class="<?= $statusColor ?> px-4 py-2 rounded-full text-sm font-medium">
            <?= Html::encode($statusList[$model->status] ?? $model->status) ?>
        </span>

        <?= Html::a('← Назад к списку', ['application/index'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>
</div>

<!-- Основная информация в стиле дизайн-проекта -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Левая колонка - детали заявки -->
    <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
        <h3 class="text-2xl font-bold text-gray-800 mb-6">Информация о заявке</h3>

        <!-- Сетка информации в 2 колонки -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Блок: Конкурс и номинация -->
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Конкурс</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= Html::encode($model->contest->title ?? 'Не указан') ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Номинация</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= Html::encode($model->nomination->name ?? 'Не указана') ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Возрастная категория</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= Html::encode($model->ageCategory->name ?? 'Не указана') ?>
                    </div>
                </div>
            </div>

            <!-- Блок: Даты и статус -->
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Дата подачи</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= date('d.m.Y H:i', strtotime($model->created_at)) ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Дата обновления</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= date('d.m.Y H:i', strtotime($model->updated_at)) ?>
                    </div>
                </div>

                <?php if ($model->status == 'approved' && isset($model->approved_at)): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Дата принятия</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                            <?= date('d.m.Y H:i', strtotime($model->approved_at)) ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Описание заявки -->

    </div>

    <!-- Правая колонка - участник и файлы -->
    <div class="space-y-6">
        <!-- Информация об участнике -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4">Участник</h3>

            <div class="space-y-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                        <span class="text-blue-600">👤</span>
                    </div>
                    <div>
                        <p class="font-medium text-gray-800">
                            <?= Html::encode($model->participant_surname) ?>
                            <?= Html::encode($model->participant_name) ?>
                            <?= Html::encode($model->participant_patronymic) ?>
                        </p>
                        <p class="text-sm text-gray-600">Основной участник</p>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Учреждение</label>
                    <p class="text-gray-900"><?= Html::encode($model->institution ?: 'Не указано') ?></p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Руководитель</label>
                    <p class="text-gray-900"><?= Html::encode($model->supervisor ?: 'Не указан') ?></p>
                </div>
            </div>
        </div>

        <!-- Файлы -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4">Прикреплённые файлы</h3>

            <div class="space-y-3">
                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-blue-600">📄</span>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Основной файл работы</p>
                            <p class="text-xs text-gray-500">
                                <?php
                                $extension = pathinfo($model->file_path, PATHINFO_EXTENSION);
                                echo strtoupper($extension) . ' файл';
                                ?>
                            </p>
                        </div>
                    </div>
                    <div class="flex space-x-2">
                        <?= Html::a('Скачать', ['application/download', 'id' => $model->id], [
                            'class' => 'bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors text-sm'
                        ]) ?>

                        <?php if (in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'pdf'])): ?>

                        <?php endif; ?>
                    </div>
                </div>

                <!-- Дополнительные файлы (если есть) -->
                <?php if (isset($model->additional_files) && !empty($model->additional_files)): ?>
                    <?php foreach (json_decode($model->additional_files, true) as $index => $file): ?>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                    <span class="text-gray-600">📎</span>
                                </div>
                                <div>
                                    <p class="font-medium text-gray-800">Доп. файл <?= $index + 1 ?></p>
                                    <p class="text-xs text-gray-500"><?= Html::encode($file['name'] ?? 'Файл') ?></p>
                                </div>
                            </div>
                            <?= Html::a('Скачать', ['application/download-additional', 'id' => $model->id, 'index' => $index], [
                                'class' => 'border border-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-50 transition-colors text-sm'
                            ]) ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <!-- Информация о размере файлов -->
            <?php if (isset($model->file_size)): ?>
                <div class="mt-4 pt-4 border-t border-gray-200">
                    <p class="text-sm text-gray-600">Общий размер файлов: <?= Yii::$app->formatter->asShortSize($model->file_size) ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>


<!-- История статусов (если есть) -->
<?php if (isset($statusHistory) && !empty($statusHistory)): ?>
    <div class="mt-6 bg-white rounded-xl shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">История изменений статуса</h3>

        <div class="space-y-4">
            <?php foreach ($statusHistory as $history): ?>
                <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                        <span class="text-blue-600">📋</span>
                    </div>
                    <div class="flex-1">
                        <p class="font-medium text-gray-800">
                            Статус изменён на:
                            <span class="inline-block ml-2 px-2 py-1 bg-blue-100 text-blue-800 rounded text-sm">
                        <?= Html::encode($statusList[$history->new_status] ?? $history->new_status) ?>
                    </span>
                        </p>
                        <p class="text-sm text-gray-600">
                            <?= date('d.m.Y H:i', strtotime($history->created_at)) ?> •
                            <?= Html::encode($history->comment ?? 'Без комментария') ?>
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>

<!-- Комментарии от организаторов (если есть) -->
<?php if (isset($model->organizer_comment) && $model->organizer_comment): ?>
    <div class="mt-6 bg-white rounded-xl shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">Комментарий организатора</h3>

        <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded-r-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-yellow-700">
                        <?= Html::encode($model->organizer_comment) ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Стили для печати -->
<style>
    @media print {
        .no-print {
            display: none !important;
        }
    }
</style>