<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Доступные конкурсы</h2>

        <?php if (!Yii::$app->user->isGuest && Yii::$app->user->identity->role === 'admin'): ?>
            <?= Html::a('+ Создать конкурс', ['admin/contest-create'], [
                'class' => 'bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium'
            ]) ?>
        <?php endif; ?>
    </div>

    <!-- Фильтры и поиск -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div class="flex-1">
                <h3 class="text-lg font-semibold text-gray-800 mb-2">Поиск конкурсов</h3>

                <form method="get" action="<?= Url::to(['']) ?>" class="flex flex-col md:flex-row gap-3">
                    <!-- Поиск по названию -->
                    <div class="flex-1">
                        <input type="text" name="search" id="search"
                               value="<?= isset($currentSearch) ? Html::encode($currentSearch) : '' ?>"
                               placeholder="Название конкурса..."
                               class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <!-- Фильтр по статусу -->
                    <div class="flex items-center">
                        <label for="status" class="text-sm text-gray-700 mr-2 whitespace-nowrap">Статус:</label>
                        <select name="status" id="status"
                                class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Все статусы</option>
                            <option value="active" <?= isset($currentStatus) && $currentStatus == 'active' ? 'selected' : '' ?>>Активные</option>
                            <option value="upcoming" <?= isset($currentStatus) && $currentStatus == 'upcoming' ? 'selected' : '' ?>>Предстоящие</option>
                            <option value="completed" <?= isset($currentStatus) && $currentStatus == 'completed' ? 'selected' : '' ?>>Завершённые</option>
                        </select>
                    </div>

                    <div class="flex space-x-2">
                        <button type="submit"
                                class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors whitespace-nowrap">
                            Найти
                        </button>
                        <a href="<?= Url::to(['contest/index']) ?>"
                           class="border border-gray-300 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-50 transition-colors whitespace-nowrap text-center">
                            Сбросить
                        </a>
                    </div>
                </form>
            </div>

            <!-- Статистика -->
            <?php
            $totalCount = count($contests);
            $activeCount = 0;
            $upcomingCount = 0;
            $completedCount = 0;

            foreach ($contests as $contest) {
                $now = time();
                $start = strtotime($contest->start_date);
                $end = strtotime($contest->end_date);

                if ($now < $start) {
                    $upcomingCount++;
                } elseif ($now <= $end) {
                    $activeCount++;
                } else {
                    $completedCount++;
                }
            }
            ?>

            <div class="text-right">
                <p class="text-sm text-gray-600">Всего конкурсов: <span class="font-bold text-gray-800"><?= $totalCount ?></span></p>
                <div class="flex gap-2 mt-1 justify-end">
                    <span class="text-xs bg-green-100 text-green-800 px-2 py-1 rounded">Активных: <?= $activeCount ?></span>
                    <span class="text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded">Скоро: <?= $upcomingCount ?></span>
                    <span class="text-xs bg-gray-100 text-gray-800 px-2 py-1 rounded">Завершено: <?= $completedCount ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Если нет конкурсов -->
<?php if (empty($contests)): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span class="text-3xl text-gray-400">🏆</span>
        </div>
        <h3 class="text-xl font-semibold text-gray-800 mb-2">Конкурсов пока нет</h3>
        <p class="text-gray-600 mb-6">Новые конкурсы появятся здесь в ближайшее время</p>

        <?php if (!Yii::$app->user->isGuest && Yii::$app->user->identity->role === 'admin'): ?>
            <?= Html::a('+ Создать первый конкурс', ['admin/contest-create'], [
                'class' => 'inline-block bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium'
            ]) ?>
        <?php else: ?>
            <?= Html::a('Обновить страницу', ['contest/index'], [
                'class' => 'inline-block bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium'
            ]) ?>
        <?php endif; ?>
    </div>
<?php else: ?>

    <!-- Сетка конкурсов в стиле дизайн-проекта -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php foreach ($contests as $contest):
            $now = time();
            $start = strtotime($contest->start_date);
            $end = strtotime($contest->end_date);

            // Определение статуса
            $status = '';
            $statusColor = '';
            $statusText = '';

            if ($now < $start) {
                $status = 'upcoming';
                $statusColor = 'bg-blue-100 text-blue-800';
                $statusText = 'Скоро начнётся';
            } elseif ($now <= $end) {
                $status = 'active';
                $statusColor = 'bg-green-100 text-green-800';
                $statusText = 'Активный';
            } else {
                $status = 'completed';
                $statusColor = 'bg-gray-100 text-gray-800';
                $statusText = 'Завершён';
            }

            // Подсчёт дней до конца/начала
            $daysLeft = '';
            if ($status == 'active') {
                $days = ceil(($end - $now) / (60 * 60 * 24));
                $daysLeft = $days > 0 ? "Осталось {$days} " . $this->pluralize($days, 'день', 'дня', 'дней') : 'Последний день';
            } elseif ($status == 'upcoming') {
                $days = ceil(($start - $now) / (60 * 60 * 24));
                $daysLeft = "Начнётся через {$days} " . $this->pluralize($days, 'день', 'дня', 'дней');
            }
            ?>
            <div class="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transition-shadow">
                <!-- Изображение конкурса -->
                <?php if ($contest->image): ?>
                    <img src="<?= Yii::$app->request->baseUrl . '/uploads/contests/' . Html::encode($contest->image) ?>"
                         class="w-full h-48 object-cover"
                         alt="<?= Html::encode($contest->title) ?>">
                <?php else: ?>
                    <!-- Заглушка если нет изображения -->
                    <div class="w-full h-48 bg-gradient-to-r from-blue-50 to-purple-50 flex items-center justify-center">
                        <span class="text-4xl">🏆</span>
                    </div>
                <?php endif; ?>

                <div class="p-6">
                    <!-- Заголовок и статус -->
                    <div class="flex justify-between items-start mb-3">
                        <h3 class="text-xl font-semibold text-gray-800">
                            <?= Html::encode($contest->title) ?>
                        </h3>
                        <span class="<?= $statusColor ?> px-2 py-1 rounded text-xs font-medium">
                        <?= $statusText ?>
                    </span>
                    </div>

                    <!-- Описание -->
                    <p class="text-gray-600 mb-4">
                        <?= Html::encode(mb_substr($contest->description, 0, 100)) ?>...
                    </p>

                    <!-- Информация о датах -->
                    <div class="space-y-2 text-sm text-gray-500 mb-4">
                        <div class="flex items-center">
                            <span class="mr-2">📅</span>
                            <span><?= date('d.m.Y', strtotime($contest->start_date)) ?> — <?= date('d.m.Y', strtotime($contest->end_date)) ?></span>
                        </div>

                        <?php if ($daysLeft): ?>
                            <div class="flex items-center">
                                <span class="mr-2">⏰</span>
                                <span class="font-medium <?= $status == 'active' ? 'text-green-600' : 'text-blue-600' ?>">
                                <?= $daysLeft ?>
                            </span>
                            </div>
                        <?php endif; ?>

                        <!-- Количество заявок (если доступно) -->
                        <?php if (isset($contest->application_count)): ?>
                            <div class="flex items-center">
                                <span class="mr-2">📋</span>
                                <span><?= $contest->application_count ?> заявок</span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Действия -->
                    <div class="space-y-2">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <a href="<?= Url::to(['site/login']) ?>"
                               class="block w-full text-center bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition-colors">
                                Войдите, чтобы подать заявку
                            </a>
                        <?php else: ?>
                            <?php if ($status == 'active'): ?>
                                <a href="<?= Url::to(['application/create', 'contest_id' => $contest->id]) ?>"
                                   class="block w-full text-center bg-green-600 text-white py-2 rounded-lg hover:bg-green-700 transition-colors mb-2">
                                    Подать заявку
                                </a>
                            <?php endif; ?>

                            <div class="flex space-x-2">
                                <a href="<?= Url::to(['contest/view', 'id' => $contest->id]) ?>"
                                   class="flex-1 text-center border border-gray-300 text-gray-700 py-2 rounded-lg hover:bg-gray-50 transition-colors">
                                    Подробнее
                                </a>

                                <?php if (Yii::$app->user->identity->role === 'admin'): ?>
                                    <a href="<?= Url::to(['admin/contest-update', 'id' => $contest->id]) ?>"
                                       class="flex-1 text-center border border-blue-300 text-blue-600 py-2 rounded-lg hover:bg-blue-50 transition-colors">
                                        Редактировать
                                    </a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Пагинация (если нужно) -->
    <?php if (isset($pagination) && $pagination->pageCount > 1): ?>
        <div class="mt-6 bg-white rounded-xl shadow-md p-6">
            <div class="flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $pagination->offset + 1 ?> - <?= min($pagination->offset + $pagination->limit, $pagination->totalCount) ?>
                    из <?= $pagination->totalCount ?> конкурсов
                </div>
                <nav class="inline-flex rounded-md shadow">
                    <?php if ($pagination->page > 0): ?>
                        <?= Html::a('← Назад', ['contest/index', 'page' => $pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-l-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 1; $i <= $pagination->pageCount; $i++): ?>
                        <?= Html::a($i, ['contest/index', 'page' => $i], [
                            'class' => 'px-4 py-2 border-t border-b border-gray-300 ' .
                                ($i == $pagination->page + 1 ? 'bg-blue-50 text-blue-600 border-blue-500' : 'hover:bg-gray-50')
                        ]) ?>
                    <?php endfor; ?>

                    <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед →', ['contest/index', 'page' => $pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-r-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
    <?php endif; ?>

<?php endif; ?>

    <!-- Дополнительная функция для склонения слов -->
<?php
// Добавьте эту функцию в View или создайте хелпер
function pluralize($number, $one, $two, $five) {
    $number = abs($number) % 100;
    if ($number > 10 && $number < 20) return $five;
    $number = $number % 10;
    if ($number == 1) return $one;
    if ($number > 1 && $number < 5) return $two;
    return $five;
}
?>