<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($model->title) ?></h2>

        <div class="flex items-center space-x-4">
            <?= Html::a('← Назад к конкурсам', ['contest/index'], [
                'class' => 'text-blue-600 hover:text-blue-800 font-medium'
            ]) ?>

            <?php if (!Yii::$app->user->isGuest && Yii::$app->user->identity->role === 'admin'): ?>
                <?= Html::a('✏️ Редактировать', ['admin/contest-update', 'id' => $model->id], [
                    'class' => 'border border-blue-300 text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 transition-colors'
                ]) ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Основной блок информации -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <!-- Изображение конкурса -->
        <?php if ($model->image): ?>
            <div class="relative">
                <img src="<?= Yii::$app->request->baseUrl . '/uploads/contests/' . Html::encode($model->image) ?>"
                     class="w-full h-64 md:h-80 object-cover"
                     alt="<?= Html::encode($model->title) ?>">

                <!-- Статус на изображении -->
                <?php
                $now = time();
                $start = strtotime($model->start_date);
                $end = strtotime($model->end_date);

                if ($now < $start) {
                    $statusColor = 'bg-blue-500';
                    $statusText = 'Скоро начнётся';
                } elseif ($now <= $end) {
                    $statusColor = 'bg-green-500';
                    $statusText = 'Идёт приём заявок';
                } else {
                    $statusColor = 'bg-gray-500';
                    $statusText = 'Завершён';
                }
                ?>
                <div class="absolute top-4 right-4 <?= $statusColor ?> text-white px-3 py-1 rounded-full text-sm font-medium">
                    <?= $statusText ?>
                </div>
            </div>
        <?php else: ?>
            <!-- Заглушка если нет изображения -->
            <div class="w-full h-64 md:h-80 bg-gradient-to-r from-blue-50 to-purple-50 flex items-center justify-center">
                <div class="text-center">
                    <span class="text-6xl mb-4 block">🏆</span>
                    <p class="text-gray-600 font-medium"><?= Html::encode($model->title) ?></p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Основной контент -->
        <div class="p-6 md:p-8">
            <!-- Описание конкурса -->
            <div class="mb-8">
                <h3 class="text-2xl font-bold text-gray-800 mb-4">Описание конкурса</h3>

            </div>

            <!-- Информация о датах -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <!-- Даты проведения -->
                <div class="bg-gray-50 rounded-lg p-6">
                    <h4 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                        <span class="mr-2">📅</span> Даты проведения
                    </h4>

                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Начало конкурса:</span>
                            <span class="font-medium text-gray-800">
                            <?= Html::encode(formatDateRuManual($model->start_date)) ?>
                        </span>
                        </div>

                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Окончание конкурса:</span>
                            <span class="font-medium text-gray-800">
                            <?= Html::encode(formatDateRuManual($model->end_date)) ?>
                        </span>
                        </div>

                        <!-- Счётчик времени -->
                        <?php
                        if ($now < $start) {
                            $days = ceil(($start - $now) / (60 * 60 * 24));
                            $timeText = "До начала осталось: {$days} " . pluralize($days, 'день', 'дня', 'дней');
                            $timeColor = 'text-blue-600';
                        } elseif ($now <= $end) {
                            $days = ceil(($end - $now) / (60 * 60 * 24));
                            if ($days > 0) {
                                $timeText = "До окончания осталось: {$days} " . pluralize($days, 'день', 'дня', 'дней');
                            } else {
                                $timeText = "Последний день приёма заявок!";
                            }
                            $timeColor = 'text-green-600';
                        } else {
                            $days = ceil(($now - $end) / (60 * 60 * 24));
                            $timeText = "Завершён {$days} " . pluralize($days, 'день', 'дня', 'дней') . " назад";
                            $timeColor = 'text-gray-600';
                        }
                        ?>

                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <p class="text-sm font-medium <?= $timeColor ?>">
                                <?= $timeText ?>
                            </p>
                        </div>
                    </div>
                </div>


            </div>

            <!-- Возрастные категории -->
            <div class="mb-8">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                    <span class="mr-2">🎂</span> Возрастные категории
                </h3>

                <div class="flex flex-wrap gap-2">
                    <?php foreach ($model->ageCategories as $cat): ?>
                        <span class="bg-blue-100 text-blue-800 px-4 py-2 rounded-lg font-medium">
                        <?= Html::encode($cat->name) ?>
                    </span>
                    <?php endforeach; ?>

                    <?php if (empty($model->ageCategories)): ?>
                        <p class="text-gray-500 italic">Возрастные категории не указаны</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Номинации -->
            <div class="mb-8">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                    <span class="mr-2">🏅</span> Номинации
                </h3>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php foreach ($model->nominations as $nom): ?>
                        <div class="bg-green-50 border border-green-100 rounded-lg p-4">
                            <h4 class="font-medium text-green-800 mb-2"><?= Html::encode($nom->name) ?></h4>

                        </div>
                    <?php endforeach; ?>

                    <?php if (empty($model->nominations)): ?>
                        <div class="col-span-full">
                            <p class="text-gray-500 italic">Номинации не указаны</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Требования и правила (если есть) -->
            <?php if (isset($model->requirements) && $model->requirements): ?>
                <div class="mb-8">
                    <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                        <span class="mr-2">📋</span> Требования и правила
                    </h3>

                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded-r-lg">
                        <div class="prose max-w-none text-gray-700 whitespace-pre-line">
                            <?= Html::encode($model->requirements) ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Кнопки действий -->
            <div class="mt-8 pt-8 border-t border-gray-200">
                <div class="flex flex-col md:flex-row gap-4">
                    <?php if (Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['site/login']) ?>"
                           class="flex-1 bg-blue-600 text-white text-center py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium">
                            🔑 Войти для участия
                        </a>

                        <a href="<?= Url::to(['site/register']) ?>"
                           class="flex-1 border border-blue-300 text-blue-600 text-center py-3 rounded-lg hover:bg-blue-50 transition-colors font-medium">
                            📝 Зарегистрироваться
                        </a>
                    <?php else: ?>
                        <?php if ($now >= $start && $now <= $end): ?>
                            <a href="<?= Url::to(['application/create', 'contest_id' => $model->id]) ?>"
                               class="flex-1 bg-green-600 text-white text-center py-3 rounded-lg hover:bg-green-700 transition-colors font-medium">
                                📋 Подать заявку
                            </a>
                        <?php elseif ($now < $start): ?>
                            <button disabled
                                    class="flex-1 bg-gray-400 text-white text-center py-3 rounded-lg font-medium cursor-not-allowed">
                                ⏳ Приём заявок начнётся <?= date('d.m.Y', $start) ?>
                            </button>
                        <?php else: ?>
                            <button disabled
                                    class="flex-1 bg-gray-400 text-white text-center py-3 rounded-lg font-medium cursor-not-allowed">
                                ⌛ Приём заявок завершён
                            </button>
                        <?php endif; ?>

                        <a href="<?= Url::to(['contest/index']) ?>"
                           class="flex-1 border border-gray-300 text-gray-700 text-center py-3 rounded-lg hover:bg-gray-50 transition-colors font-medium">
                            ← Назад к конкурсам
                        </a>

                        <?php if (!Yii::$app->user->isGuest && Yii::$app->user->identity->role === 'participant'): ?>
                            <a href="<?= Url::to(['application/index']) ?>"
                               class="flex-1 border border-blue-300 text-blue-600 text-center py-3 rounded-lg hover:bg-blue-50 transition-colors font-medium">
                                📄 Мои заявки
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Вспомогательные функции -->
<?php
/**
 * Форматирует дату в вида "3 декабря 2025"
 * Работает всегда (без intl)
 */
function formatDateRuManual($date)
{
    if (!$date) {
        return '';
    }

    $ts = strtotime($date);
    if ($ts === false) {
        return Html::encode($date);
    }

    $day = date('j', $ts);
    $monthNum = (int)date('n', $ts);
    $year = date('Y', $ts);

    $months = [
        1 => 'января', 2 => 'февраля', 3 => 'марта', 4 => 'апреля',
        5 => 'мая', 6 => 'июня', 7 => 'июля', 8 => 'августа',
        9 => 'сентября', 10 => 'октября', 11 => 'ноября', 12 => 'декабря'
    ];

    return $day . ' ' . ($months[$monthNum] ?? '') . ' ' . $year;
}

/**
 * Склонение слов (день/дня/дней)
 */
function pluralize($number, $one, $two, $five) {
    $number = abs($number) % 100;
    if ($number > 10 && $number < 20) return $five;
    $number = $number % 10;
    if ($number == 1) return $one;
    if ($number > 1 && $number < 5) return $two;
    return $five;
}
?>