<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $application app\models\Application */
/* @var $evaluation app\models\Evaluation */

$this->title = 'Оценка заявки: ' . $application->title;
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>

    <div class="flex items-center space-x-4">
        <?= Html::a('← Назад к назначениям', ['expert/index'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>

        <!-- Статус оценки -->
        <span class="px-4 py-2 rounded-full text-sm font-medium
            <?= $evaluation->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' ?>">
            <?= $evaluation->status === 'completed' ? '✅ Оценка завершена' : '✏️ Черновик' ?>
        </span>
    </div>
</div>

<!-- Если оценка завершена -->
<?php if ($evaluation->status === 'completed'): ?>
    <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-r-lg">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <p class="text-sm text-green-700">
                    <strong>Оценка завершена и отправлена.</strong> Вы можете просмотреть результаты, но не можете их изменить.
                    Для внесения изменений обратитесь к администратору.
                </p>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Левая колонка - информация о заявке -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-xl shadow-md p-6 mb-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">📋</span> Информация о заявке
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Участник</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                        <?= Html::encode($application->participant_surname) ?>
                        <?= Html::encode($application->participant_name) ?>
                        <?= Html::encode($application->participant_patronymic) ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Возрастная категория</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                        <?= Html::encode($application->ageCategory->name ?? 'Не указана') ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Название работы</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                        <?= Html::encode($application->title) ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Номинация</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                        <?= Html::encode($application->nomination->name ?? 'Не указана') ?>
                    </div>
                </div>
            </div>

            <!-- Описание работы -->


            <!-- Файл работы -->
            <div class="mt-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Файл работы</label>
                <div class="flex items-center p-3 bg-blue-50 rounded-lg border border-blue-100">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                        <span class="text-blue-600">📄</span>
                    </div>
                    <div class="flex-1">
                        <p class="font-medium text-gray-800">Основной файл работы</p>
                        <p class="text-xs text-gray-600">Нажмите для просмотра или скачивания</p>
                    </div>
                    <div class="flex space-x-2">
                        <?= Html::a('Скачать', ['application/download', 'id' => $application->id], [
                            'class' => 'bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors text-sm',
                            'target' => '_blank'
                        ]) ?>

                        <?php
                        $extension = pathinfo($application->file_path, PATHINFO_EXTENSION);
                        if (in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'pdf'])): ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Форма оценки -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                <span class="mr-2">⭐</span> Оценочный лист
            </h3>

            <?php $form = ActiveForm::begin([
                'id' => 'evaluation-form',
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <!-- Критерии оценки -->
            <div class="space-y-6">
                <!-- Мастерство -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="flex justify-between items-center mb-2">
                        <label class="block text-lg font-medium text-gray-800">Мастерство исполнения</label>
                        <span class="text-sm text-gray-500">0–8 баллов</span>
                    </div>
                    <p class="text-sm text-gray-600 mb-3">
                        Техническое мастерство, качество исполнения, сложность работы, соответствие заявленному уровню
                    </p>
                    <?= $form->field($evaluation, 'mastery', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 8,
                            'id' => 'mastery-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Шкала оценки -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>Низкий уровень</span>
                            <span>Высокий уровень</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-500 h-2 rounded-full" id="mastery-bar"></div>
                        </div>
                        <div class="flex justify-between mt-1">
                            <?php for ($i = 0; $i <= 8; $i++): ?>
                                <span class="text-xs text-gray-500 w-6 text-center"><?= $i ?></span>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>

                <!-- Артистизм -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="flex justify-between items-center mb-2">
                        <label class="block text-lg font-medium text-gray-800">Артистизм и выразительность</label>
                        <span class="text-sm text-gray-500">0–8 баллов</span>
                    </div>
                    <p class="text-sm text-gray-600 mb-3">
                        Художественная выразительность, эмоциональная насыщенность, оригинальность, творческий подход
                    </p>
                    <?= $form->field($evaluation, 'artistry', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 8,
                            'id' => 'artistry-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Шкала оценки -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>Слабая выразительность</span>
                            <span>Высокая выразительность</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-purple-500 h-2 rounded-full" id="artistry-bar"></div>
                        </div>
                        <div class="flex justify-between mt-1">
                            <?php for ($i = 0; $i <= 8; $i++): ?>
                                <span class="text-xs text-gray-500 w-6 text-center"><?= $i ?></span>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>

                <!-- Сценическая культура -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="flex justify-between items-center mb-2">
                        <label class="block text-lg font-medium text-gray-800">Сценическая культура</label>
                        <span class="text-sm text-gray-500">0–8 баллов</span>
                    </div>
                    <p class="text-sm text-gray-600 mb-3">
                        Соблюдение сценических норм, культура исполнения, работа с пространством, соответствие жанру
                    </p>
                    <?= $form->field($evaluation, 'stage_culture', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 8,
                            'id' => 'culture-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Шкала оценки -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>Низкий уровень</span>
                            <span>Высокий уровень</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-500 h-2 rounded-full" id="culture-bar"></div>
                        </div>
                        <div class="flex justify-between mt-1">
                            <?php for ($i = 0; $i <= 8; $i++): ?>
                                <span class="text-xs text-gray-500 w-6 text-center"><?= $i ?></span>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Итоговый балл -->
            <div class="mt-8 p-4 bg-blue-50 rounded-lg">
                <div class="flex justify-between items-center">
                    <div>
                        <h4 class="font-semibold text-gray-800">Общий балл</h4>
                        <p class="text-sm text-gray-600">Сумма всех критериев оценки</p>
                    </div>
                    <div class="text-center">
                        <div class="text-4xl font-bold text-blue-600" id="total-score">
                            <?= Html::encode($evaluation->getTotal()) ?>
                        </div>
                        <div class="text-sm text-gray-500">из 24 максимальных</div>
                    </div>
                </div>

                <!-- Прогресс-бар итогового балла -->
                <div class="mt-4">
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600">Общая оценка</span>
                        <span class="font-medium"><span id="total-percent">0</span>%</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-3">
                        <div class="bg-gradient-to-r from-blue-500 to-green-500 h-3 rounded-full"
                             id="total-progress" style="width: 0%"></div>
                    </div>
                    <div class="flex justify-between text-xs text-gray-500 mt-1">
                        <span>0 (неудовлетворительно)</span>
                        <span>12 (удовлетворительно)</span>
                        <span>18 (хорошо)</span>
                        <span>24 (отлично)</span>
                    </div>
                </div>
            </div>

            <!-- Комментарии -->
            <div class="mt-6">
                <?= $form->field($evaluation, 'notes', [
                    'labelOptions' => ['class' => 'block text-lg font-medium text-gray-700 mb-2'],
                    'inputOptions' => [
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                        'rows' => 5,
                        'placeholder' => 'Введите ваши комментарии, замечания, рекомендации...',
                        'disabled' => $evaluation->status === 'completed'
                    ]
                ])->textarea()->label('Комментарии и рекомендации') ?>
            </div>

            <!-- Кнопки действий -->
            <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
                <?php if ($evaluation->status !== 'completed'): ?>
                    <?= Html::submitButton('💾 Сохранить черновик', [
                        'class' => 'flex-1 bg-gray-600 text-white py-3 rounded-lg hover:bg-gray-700 transition-colors font-medium',
                        'name' => 'save_draft'
                    ]) ?>

                    <?= Html::submitButton('✅ Завершить оценку', [
                        'class' => 'flex-1 bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 transition-colors font-medium',
                        'name' => 'complete_evaluation',
                        'data' => [
                            'confirm' => 'Вы уверены, что хотите завершить оценку? После завершения изменить оценку будет невозможно.',
                            'method' => 'post',
                        ]
                    ]) ?>
                <?php else: ?>
                    <button disabled
                            class="flex-1 bg-gray-400 text-white py-3 rounded-lg font-medium cursor-not-allowed">
                        🚫 Изменения недоступны
                    </button>
                <?php endif; ?>

                <?= Html::a('↩️ Отмена', ['expert/index'], [
                    'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <!-- Правая колонка - информация об оценке -->
    <div class="space-y-6">
        <!-- Информация об оценке -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">📊</span> Информация об оценке
            </h3>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Статус оценки</label>
                    <div class="flex items-center">
                        <span class="w-3 h-3 rounded-full mr-2
                            <?= $evaluation->status === 'completed' ? 'bg-green-500' : 'bg-yellow-500' ?>"></span>
                        <span class="font-medium text-gray-800">
                            <?= $evaluation->status === 'completed' ? 'Завершена' : 'Черновик' ?>
                        </span>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Создана</label>
                    <div class="text-gray-900">
                        <?= Yii::$app->formatter->asDatetime($evaluation->created_at, 'php:d.m.Y H:i') ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Последнее обновление</label>
                    <div class="text-gray-900">
                        <?= Yii::$app->formatter->asDatetime($evaluation->updated_at, 'php:d.m.Y H:i') ?>
                    </div>
                </div>

                <?php if ($evaluation->status === 'completed'): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Завершена</label>
                        <div class="text-gray-900">
                            <?= Yii::$app->formatter->asDatetime($evaluation->completed_at ?? $evaluation->updated_at, 'php:d.m.Y H:i') ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <!-- Информация о конкурсе -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">🏆</span> Информация о конкурсе
            </h3>

            <div class="space-y-3">
                <div>
                    <p class="font-medium text-gray-800"><?= Html::encode($application->contest->title ?? '') ?></p>
                </div>

                <div class="text-sm text-gray-600">
                    <p>📅 До <?= date('d.m.Y', strtotime($application->contest->end_date ?? '')) ?></p>
                </div>

                <div class="pt-3 border-t border-gray-200">
                    <?= Html::a('Перейти к конкурсу →', ['contest/view', 'id' => $application->contest_id], [
                        'class' => 'text-blue-600 hover:text-blue-800 text-sm font-medium'
                    ]) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript для динамического пересчёта баллов -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Элементы
        const masteryInput = document.getElementById('mastery-score');
        const artistryInput = document.getElementById('artistry-score');
        const cultureInput = document.getElementById('culture-score');
        const masteryBar = document.getElementById('mastery-bar');
        const artistryBar = document.getElementById('artistry-bar');
        const cultureBar = document.getElementById('culture-bar');
        const totalScore = document.getElementById('total-score');
        const totalPercent = document.getElementById('total-percent');
        const totalProgress = document.getElementById('total-progress');

        // Функция обновления прогресс-баров
        function updateProgressBars() {
            // Прогресс-бары критериев
            if (masteryInput && masteryBar) {
                const masteryValue = parseInt(masteryInput.value) || 0;
                masteryBar.style.width = (masteryValue / 8 * 100) + '%';
            }

            if (artistryInput && artistryBar) {
                const artistryValue = parseInt(artistryInput.value) || 0;
                artistryBar.style.width = (artistryValue / 8 * 100) + '%';
            }

            if (cultureInput && cultureBar) {
                const cultureValue = parseInt(cultureInput.value) || 0;
                cultureBar.style.width = (cultureValue / 8 * 100) + '%';
            }

            // Общий балл
            if (masteryInput && artistryInput && cultureInput && totalScore) {
                const mastery = parseInt(masteryInput.value) || 0;
                const artistry = parseInt(artistryInput.value) || 0;
                const culture = parseInt(cultureInput.value) || 0;
                const total = mastery + artistry + culture;

                totalScore.textContent = total;

                // Процент от максимального (24)
                const percent = Math.round((total / 24) * 100);
                if (totalPercent) totalPercent.textContent = percent;
                if (totalProgress) totalProgress.style.width = percent + '%';

                // Цвет итогового прогресс-бара
                if (totalProgress) {
                    if (percent < 50) {
                        totalProgress.className = 'bg-red-500 h-3 rounded-full';
                    } else if (percent < 75) {
                        totalProgress.className = 'bg-yellow-500 h-3 rounded-full';
                    } else {
                        totalProgress.className = 'bg-green-500 h-3 rounded-full';
                    }
                }
            }
        }

        // Обработчики событий
        if (masteryInput) {
            masteryInput.addEventListener('input', updateProgressBars);
            masteryInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 8) this.value = 8;
                updateProgressBars();
            });
        }

        if (artistryInput) {
            artistryInput.addEventListener('input', updateProgressBars);
            artistryInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 8) this.value = 8;
                updateProgressBars();
            });
        }

        if (cultureInput) {
            cultureInput.addEventListener('input', updateProgressBars);
            cultureInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 8) this.value = 8;
                updateProgressBars();
            });
        }

        // Инициализация
        updateProgressBars();

        // Валидация формы
        const form = document.getElementById('evaluation-form');
        if (form) {
            form.addEventListener('submit', function(e) {
                const mastery = parseInt(masteryInput.value) || 0;
                const artistry = parseInt(artistryInput.value) || 0;
                const culture = parseInt(cultureInput.value) || 0;

                // Проверка диапазонов
                if (mastery < 0 || mastery > 8) {
                    e.preventDefault();
                    alert('Оценка "Мастерство" должна быть в диапазоне 0-8');
                    masteryInput.focus();
                    return;
                }

                if (artistry < 0 || artistry > 8) {
                    e.preventDefault();
                    alert('Оценка "Артистизм" должна быть в диапазоне 0-8');
                    artistryInput.focus();
                    return;
                }

                if (culture < 0 || culture > 8) {
                    e.preventDefault();
                    alert('Оценка "Сценическая культура" должна быть в диапазоне 0-8');
                    cultureInput.focus();
                    return;
                }

                // Подтверждение завершения
                if (e.submitter && e.submitter.name === 'complete_evaluation') {
                    const total = mastery + artistry + culture;
                    if (total === 0) {
                        if (!confirm('Вы собираетесь поставить общий балл 0. Вы уверены?')) {
                            e.preventDefault();
                            return;
                        }
                    }
                }
            });
        }
    });
</script>