<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\grid\GridView;

/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $contests app\models\Contest[] */
/* @var $nominations app\models\Nomination[] */
/* @var $ageCategories app\models\AgeCategory[] */
/* @var $stats array */

$this->title = 'Мои назначения';
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>

    <!-- Статистика -->
    <?php if (isset($stats)): ?>
        <div class="flex items-center space-x-4">
            <div class="text-right">
                <div class="text-sm text-gray-600">Всего назначений: <span class="font-bold text-gray-800"><?= $stats['total'] ?? 0 ?></span></div>
                <div class="flex gap-2 mt-1">
                    <span class="text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded">Новые: <?= $stats['pending'] ?? 0 ?></span>
                    <span class="text-xs bg-green-100 text-green-800 px-2 py-1 rounded">Оценено: <?= $stats['completed'] ?? 0 ?></span>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Фильтры в стиле дизайн-проекта -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Фильтры поиска</h3>

    <?php $form = ActiveForm::begin([
        'method' => 'get',
        'action' => ['index'],
        'options' => ['class' => 'space-y-4']
    ]); ?>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        <!-- Фильтр по конкурсу -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Конкурс</label>
            <?= Html::dropDownList('contest_id',
                Yii::$app->request->get('contest_id'),
                \yii\helpers\ArrayHelper::map($contests, 'id', 'title'),
                [
                    'prompt' => 'Все конкурсы',
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]) ?>
        </div>

        <!-- Фильтр по номинации -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Номинация</label>
            <?= Html::dropDownList('nomination_id',
                Yii::$app->request->get('nomination_id'),
                \yii\helpers\ArrayHelper::map($nominations, 'id', 'name'),
                [
                    'prompt' => 'Все номинации',
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]) ?>
        </div>

        <!-- Фильтр по возрастной категории -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Возрастная категория</label>
            <?= Html::dropDownList('age_category_id',
                Yii::$app->request->get('age_category_id'),
                \yii\helpers\ArrayHelper::map($ageCategories, 'id', 'name'),
                [
                    'prompt' => 'Все категории',
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]) ?>
        </div>

        <!-- Фильтр по статусу оценки -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Статус оценки</label>
            <?= Html::dropDownList('eval_status',
                Yii::$app->request->get('eval_status'),
                [
                    'pending' => 'Требует оценки',
                    'draft' => 'Черновик',
                    'completed' => 'Завершено'
                ],
                [
                    'prompt' => 'Все статусы',
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]) ?>
        </div>
    </div>

    <!-- Кнопки фильтров -->
    <div class="flex space-x-4 pt-4">
        <?= Html::submitButton('Применить фильтры', [
            'class' => 'bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium'
        ]) ?>

        <?= Html::a('Сбросить фильтры', ['index'], [
            'class' => 'border border-gray-300 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-50 transition-colors'
        ]) ?>

        <?php if (isset($stats) && ($stats['pending'] ?? 0) > 0): ?>
            <?= Html::a('Случайная заявка', ['expert/random'], [
                'class' => 'border border-green-300 text-green-600 px-6 py-2 rounded-lg hover:bg-green-50 transition-colors'
            ]) ?>
        <?php endif; ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<!-- Информация для эксперта -->
<div class="mt-6">
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <p class="text-xl text-blue-700">
                    <strong>Информация для эксперта:</strong> Оценивайте заявки объективно и своевременно.
                    Завершённые оценки участники недоступны для изменения.
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Статистика в карточках -->
<?php if (isset($stats)): ?>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-blue-600">📋</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['total'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Всего назначений</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-yellow-600">⏳</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['pending'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Требуют оценки</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-green-600">✓</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['completed'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Оценено</p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Если нет назначений -->
<?php if ($dataProvider->getTotalCount() == 0): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span class="text-3xl text-gray-400">📝</span>
        </div>
        <h3 class="text-xl font-semibold text-gray-800 mb-2">Нет назначенных заявок</h3>
        <p class="text-gray-600 mb-6">На данный момент вам не назначены заявки для оценки</p>

        <div class="space-x-4">
            <?= Html::a('Обновить страницу', ['expert/index'], [
                'class' => 'inline-block bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors'
            ]) ?>

            <?= Html::a('Моя статистика', ['expert/statistics'], [
                'class' => 'inline-block border border-gray-300 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-50 transition-colors'
            ]) ?>
        </div>
    </div>
<?php else: ?>
<br>
    <!-- Таблица заявок в стиле дизайн-проекта -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <!-- Заголовок таблицы -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-2xl font-bold text-gray-800">Список заявок для оценки</h3>
                <p class="text-sm text-gray-600">
                    Найдено: <span class="font-bold text-gray-800"><?= $dataProvider->getTotalCount() ?></span> заявок
                </p>
            </div>
        </div>

        <!-- Кастомная таблица вместо GridView для полного контроля стилей -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="bg-gray-50">
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">№</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Заявка</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Участник</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Конкурс</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Номинация</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Дата</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                <?php
                $models = $dataProvider->getModels();
                $i = 1;
                foreach ($models as $model):
                    // Определение статуса оценки
                    $evaluation = $model->getEvaluations()->where(['expert_id' => Yii::$app->user->id])->one();
                    $status = $evaluation ? $evaluation->status : 'pending';

                    $statusColor = 'bg-gray-100 text-gray-800';
                    $statusText = 'Требует оценки';

                    if ($status == 'draft') {
                        $statusColor = 'bg-yellow-100 text-yellow-800';
                        $statusText = 'Черновик';
                    } elseif ($status == 'completed') {
                        $statusColor = 'bg-green-100 text-green-800';
                        $statusText = 'Оценено';
                    }
                    ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="py-4 px-6 text-gray-600"><?= $i++ ?></td>

                        <td class="py-4 px-6">
                            <div class="font-medium text-gray-800"><?= Html::encode($model->title) ?></div>
                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800">
                                <?= Html::encode($model->participant_surname) ?>
                                <?= Html::encode($model->participant_name) ?>
                            </div>
                            <div class="text-xs text-gray-500">
                                <?= Html::encode($model->ageCategory->name ?? '') ?>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800"><?= Html::encode($model->contest->title ?? '') ?></div>
                            <div class="text-xs text-gray-500">
                                <?= date('d.m.Y', strtotime($model->contest->end_date ?? '')) ?>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                        <span class="px-2 py-1 bg-blue-50 text-blue-700 rounded text-sm">
                            <?= Html::encode($model->nomination->name ?? '') ?>
                        </span>
                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800">
                                <?= Yii::$app->formatter->asDate($model->created_at, 'php:d.m.Y') ?>
                            </div>
                            <div class="text-xs text-gray-500">
                                <?= date('H:i', strtotime($model->created_at)) ?>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                        <span class="<?= $statusColor ?> px-3 py-1 rounded-full text-sm font-medium">
                            <?= $statusText ?>
                        </span>
                        </td>

                        <td class="py-4 px-6">
                            <div class="flex space-x-2">
                                <?php if ($status == 'pending' || $status == 'draft'): ?>
                                    <?= Html::a('Оценить', ['expert/evaluate', 'id' => $model->id], [
                                        'class' => 'bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors text-sm font-medium'
                                    ]) ?>
                                <?php else: ?>


                                    <?= Html::a('Изменить', ['expert/evaluate', 'id' => $model->id], [
                                        'class' => 'border border-blue-300 text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 transition-colors text-sm font-medium'
                                    ]) ?>
                                <?php endif; ?>

                                <?= Html::a('Файл', ['application/download', 'id' => $model->id], [
                                    'class' => 'border border-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-50 transition-colors text-sm font-medium',
                                    'target' => '_blank'
                                ]) ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php
        $pagination = $dataProvider->getPagination();
        if ($pagination && $pagination->pageCount > 1): ?>
            <div class="p-6 border-t border-gray-200">
                <div class="flex justify-between items-center">
                    <div class="text-sm text-gray-600">
                        Показано <?= $pagination->offset + 1 ?> - <?= min($pagination->offset + $pagination->limit, $pagination->totalCount) ?>
                        из <?= $pagination->totalCount ?> заявок
                    </div>
                    <nav class="inline-flex rounded-md shadow">
                        <?php if ($pagination->page > 0): ?>
                            <?= Html::a('← Назад', array_merge(['expert/index'], $pagination->params, ['page' => $pagination->page]), [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-l-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>

                        <?php for ($i = 1; $i <= $pagination->pageCount; $i++): ?>
                            <?= Html::a($i, array_merge(['expert/index'], $pagination->params, ['page' => $i]), [
                                'class' => 'px-4 py-2 border-t border-b border-gray-300 ' .
                                    ($i == $pagination->page + 1 ? 'bg-blue-50 text-blue-600 border-blue-500' : 'hover:bg-gray-50')
                            ]) ?>
                        <?php endfor; ?>

                        <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                            <?= Html::a('Вперед →', array_merge(['expert/index'], $pagination->params, ['page' => $pagination->page + 2]), [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-r-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
    </div>



<?php endif; ?>

