<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $model app\models\Application */
/* @var $evaluation app\models\Evaluation */
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Заявка: <?= Html::encode($model->title) ?></h2>

    <div class="flex items-center space-x-4">
        <!-- Статус оценки -->
        <span class="px-4 py-2 rounded-full text-sm font-medium
            <?= $evaluation->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' ?>">
            <?= $evaluation->status === 'completed' ? '✅ Оценка завершена' : '✏️ Черновик оценки' ?>
        </span>

        <?= Html::a('← Назад к назначениям', ['expert/index'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Левая колонка - информация о заявке -->
    <div class="lg:col-span-2">
        <!-- Информация о заявке -->
        <div class="bg-white rounded-xl shadow-md p-6 mb-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">📋</span> Информация о заявке
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Левая колонка -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Конкурс</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                            <?= Html::encode($model->contest->title ?? 'Не указан') ?>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Номинация</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                            <?= Html::encode($model->nomination->name ?? 'Не указана') ?>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Возрастная категория</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                            <?= Html::encode($model->ageCategory->name ?? 'Не указана') ?>
                        </div>
                    </div>
                </div>

                <!-- Правая колонка -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Участник</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                            <?= Html::encode($model->user->surname ?? '') ?>
                            <?= Html::encode($model->user->name ?? '') ?>
                            <?= Html::encode($model->user->patronymic ?? '') ?>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Руководитель</label>
                        <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3">
                            <?= Html::encode($model->supervisor ?: 'Не указан') ?>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Файл работы</label>
                        <div class="flex items-center p-3 bg-blue-50 rounded-lg border border-blue-100">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <span class="text-blue-600">📄</span>
                            </div>
                            <div class="flex-1">
                                <p class="font-medium text-gray-800">Основной файл</p>
                                <p class="text-xs text-gray-600"><?= Html::encode(basename($model->file_path)) ?></p>
                            </div>
                            <?= Html::a('Скачать', '/uploads/' . Html::encode(basename($model->file_path)), [
                                'class' => 'bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors text-sm',
                                'target' => '_blank'
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Описание работы -->
            <?php if ($model->description): ?>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Описание работы</label>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-gray-900 whitespace-pre-line"><?= Html::encode($model->description) ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Форма оценки -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                <span class="mr-2">⭐</span> Оценочный лист
            </h3>

            <?php $form = ActiveForm::begin([
                'id' => 'evaluation-form',
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <!-- Критерии оценки -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Мастерство -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="text-center mb-3">
                        <label class="block text-lg font-medium text-gray-800 mb-1">Мастерство</label>
                        <span class="text-sm text-gray-500">0–100 баллов</span>
                    </div>
                    <?= $form->field($evaluation, 'mastery', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 100,
                            'id' => 'mastery-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Прогресс-бар -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>0</span>
                            <span>50</span>
                            <span>100</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-500 h-2 rounded-full" id="mastery-bar"></div>
                        </div>
                    </div>
                </div>

                <!-- Артистизм -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="text-center mb-3">
                        <label class="block text-lg font-medium text-gray-800 mb-1">Артистизм</label>
                        <span class="text-sm text-gray-500">0–100 баллов</span>
                    </div>
                    <?= $form->field($evaluation, 'artistry', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 100,
                            'id' => 'artistry-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Прогресс-бар -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>0</span>
                            <span>50</span>
                            <span>100</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-purple-500 h-2 rounded-full" id="artistry-bar"></div>
                        </div>
                    </div>
                </div>

                <!-- Сценическая культура -->
                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                    <div class="text-center mb-3">
                        <label class="block text-lg font-medium text-gray-800 mb-1">Сценическая культура</label>
                        <span class="text-sm text-gray-500">0–100 баллов</span>
                    </div>
                    <?= $form->field($evaluation, 'stage_culture', [
                        'options' => ['class' => 'mb-0'],
                        'inputOptions' => [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-lg font-medium text-center',
                            'type' => 'number',
                            'min' => 0,
                            'max' => 100,
                            'id' => 'culture-score',
                            'disabled' => $evaluation->status === 'completed'
                        ]
                    ])->label(false)->hint(false) ?>

                    <!-- Прогресс-бар -->
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-500 mb-1">
                            <span>0</span>
                            <span>50</span>
                            <span>100</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-500 h-2 rounded-full" id="culture-bar"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Итоговый балл -->
            <div class="mt-8 p-4 bg-blue-50 rounded-lg">
                <div class="flex justify-between items-center">
                    <div>
                        <h4 class="font-semibold text-gray-800">Общий балл</h4>
                        <p class="text-sm text-gray-600">Сумма всех критериев оценки</p>
                    </div>
                    <div class="text-center">
                        <div class="text-4xl font-bold text-blue-600" id="total-score">
                            <?= Html::encode(($evaluation->mastery ?? 0) + ($evaluation->artistry ?? 0) + ($evaluation->stage_culture ?? 0)) ?>
                        </div>
                        <div class="text-sm text-gray-500">из 300 максимальных</div>
                    </div>
                </div>

                <!-- Прогресс-бар итогового балла -->
                <div class="mt-4">
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600">Общая оценка</span>
                        <span class="font-medium"><span id="total-percent">0</span>%</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-3">
                        <div class="bg-gradient-to-r from-blue-500 to-green-500 h-3 rounded-full"
                             id="total-progress" style="width: 0%"></div>
                    </div>
                    <div class="flex justify-between text-xs text-gray-500 mt-1">
                        <span>0</span>
                        <span>100</span>
                        <span>200</span>
                        <span>300</span>
                    </div>
                </div>
            </div>

            <!-- Комментарии -->
            <div class="mt-6">
                <?= $form->field($evaluation, 'notes', [
                    'labelOptions' => ['class' => 'block text-lg font-medium text-gray-700 mb-2'],
                    'inputOptions' => [
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                        'rows' => 5,
                        'placeholder' => 'Введите ваши комментарии, замечания, рекомендации...',
                        'disabled' => $evaluation->status === 'completed'
                    ]
                ])->textarea()->label('Комментарии и рекомендации') ?>
            </div>

            <!-- Кнопки действий -->
            <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
                <?php if ($evaluation->status !== 'completed'): ?>
                    <?= Html::submitButton('💾 Сохранить черновик', [
                        'class' => 'flex-1 bg-gray-600 text-white py-3 rounded-lg hover:bg-gray-700 transition-colors font-medium',
                        'name' => 'save_draft'
                    ]) ?>

                    <?= Html::submitButton('✅ Завершить оценку', [
                        'class' => 'flex-1 bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 transition-colors font-medium',
                        'name' => 'complete',
                        'value' => '1',
                        'data' => [
                            'confirm' => 'Вы уверены, что хотите завершить оценку? После завершения изменить оценку будет невозможно.',
                            'method' => 'post',
                        ]
                    ]) ?>
                <?php else: ?>
                    <button disabled
                            class="flex-1 bg-gray-400 text-white py-3 rounded-lg font-medium cursor-not-allowed">
                        🚫 Изменения недоступны
                    </button>
                <?php endif; ?>

                <?= Html::a('↩️ Отмена', ['expert/index'], [
                    'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <!-- Правая колонка - информация об оценке -->
    <div class="space-y-6">
        <!-- Информация об оценке -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">📊</span> Информация об оценке
            </h3>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Статус оценки</label>
                    <div class="flex items-center">
                        <span class="w-3 h-3 rounded-full mr-2
                            <?= $evaluation->status === 'completed' ? 'bg-green-500' : 'bg-yellow-500' ?>"></span>
                        <span class="font-medium text-gray-800">
                            <?= $evaluation->status === 'completed' ? 'Завершена' : 'Черновик' ?>
                        </span>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Создана</label>
                    <div class="text-gray-900">
                        <?= $evaluation->created_at ? Yii::$app->formatter->asDatetime($evaluation->created_at, 'php:d.m.Y H:i') : '—' ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Последнее обновление</label>
                    <div class="text-gray-900">
                        <?= $evaluation->updated_at ? Yii::$app->formatter->asDatetime($evaluation->updated_at, 'php:d.m.Y H:i') : '—' ?>
                    </div>
                </div>

                <?php if ($evaluation->status === 'completed'): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Завершена</label>
                        <div class="text-gray-900">
                            <?= $evaluation->completed_at ? Yii::$app->formatter->asDatetime($evaluation->completed_at, 'php:d.m.Y H:i') :
                                ($evaluation->updated_at ? Yii::$app->formatter->asDatetime($evaluation->updated_at, 'php:d.m.Y H:i') : '—') ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Дополнительная информация -->
            <div class="mt-6 pt-6 border-t border-gray-200">
                <h4 class="font-semibold text-gray-800 mb-2">Критерии оценки</h4>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li class="flex items-center">
                        <span class="w-2 h-2 bg-blue-500 rounded-full mr-2"></span>
                        <span>Мастерство: техническое качество исполнения</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-2 h-2 bg-purple-500 rounded-full mr-2"></span>
                        <span>Артистизм: выразительность и эмоциональность</span>
                    </li>
                    <li class="flex items-center">
                        <span class="w-2 h-2 bg-green-500 rounded-full mr-2"></span>
                        <span>Сценическая культура: соответствие нормам</span>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Детали заявки -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">🏆</span> Детали конкурса
            </h3>

            <div class="space-y-3">
                <div>
                    <p class="font-medium text-gray-800"><?= Html::encode($model->contest->title ?? '') ?></p>
                    <?php if ($model->contest->start_date && $model->contest->end_date): ?>
                        <p class="text-sm text-gray-600">
                            📅 <?= date('d.m.Y', strtotime($model->contest->start_date)) ?> —
                            <?= date('d.m.Y', strtotime($model->contest->end_date)) ?>
                        </p>
                    <?php endif; ?>
                </div>

                <?php if ($model->institution): ?>
                    <div class="pt-2 border-t border-gray-100">
                        <p class="text-sm font-medium text-gray-700">Учреждение:</p>
                        <p class="text-sm text-gray-600"><?= Html::encode($model->institution) ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Быстрые действия -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                <span class="mr-2">⚡</span> Быстрые действия
            </h3>

            <div class="space-y-2">
                <?= Html::a('📋 Следующая заявка', ['expert/random'], [
                    'class' => 'block w-full text-left bg-blue-50 hover:bg-blue-100 border border-blue-200 text-blue-700 px-4 py-3 rounded-lg transition-colors'
                ]) ?>

                <?= Html::a('📊 Моя статистика', ['expert/statistics'], [
                    'class' => 'block w-full text-left bg-gray-50 hover:bg-gray-100 border border-gray-200 text-gray-700 px-4 py-3 rounded-lg transition-colors'
                ]) ?>

                <?= Html::a('📝 Все назначения', ['expert/index'], [
                    'class' => 'block w-full text-left bg-green-50 hover:bg-green-100 border border-green-200 text-green-700 px-4 py-3 rounded-lg transition-colors'
                ]) ?>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript для динамического пересчёта баллов -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Элементы
        const masteryInput = document.getElementById('mastery-score');
        const artistryInput = document.getElementById('artistry-score');
        const cultureInput = document.getElementById('culture-score');
        const masteryBar = document.getElementById('mastery-bar');
        const artistryBar = document.getElementById('artistry-bar');
        const cultureBar = document.getElementById('culture-bar');
        const totalScore = document.getElementById('total-score');
        const totalPercent = document.getElementById('total-percent');
        const totalProgress = document.getElementById('total-progress');

        // Функция обновления прогресс-баров
        function updateProgressBars() {
            // Прогресс-бары критериев
            if (masteryInput && masteryBar) {
                const masteryValue = parseInt(masteryInput.value) || 0;
                masteryBar.style.width = (masteryValue / 100 * 100) + '%';
            }

            if (artistryInput && artistryBar) {
                const artistryValue = parseInt(artistryInput.value) || 0;
                artistryBar.style.width = (artistryValue / 100 * 100) + '%';
            }

            if (cultureInput && cultureBar) {
                const cultureValue = parseInt(cultureInput.value) || 0;
                cultureBar.style.width = (cultureValue / 100 * 100) + '%';
            }

            // Общий балл
            if (masteryInput && artistryInput && cultureInput && totalScore) {
                const mastery = parseInt(masteryInput.value) || 0;
                const artistry = parseInt(artistryInput.value) || 0;
                const culture = parseInt(cultureInput.value) || 0;
                const total = mastery + artistry + culture;

                totalScore.textContent = total;

                // Процент от максимального (300)
                const percent = Math.round((total / 300) * 100);
                if (totalPercent) totalPercent.textContent = percent;
                if (totalProgress) totalProgress.style.width = percent + '%';

                // Цвет итогового прогресс-бара
                if (totalProgress) {
                    if (percent < 50) {
                        totalProgress.className = 'bg-red-500 h-3 rounded-full';
                    } else if (percent < 75) {
                        totalProgress.className = 'bg-yellow-500 h-3 rounded-full';
                    } else {
                        totalProgress.className = 'bg-green-500 h-3 rounded-full';
                    }
                }
            }
        }

        // Обработчики событий
        if (masteryInput) {
            masteryInput.addEventListener('input', updateProgressBars);
            masteryInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 100) this.value = 100;
                updateProgressBars();
            });
        }

        if (artistryInput) {
            artistryInput.addEventListener('input', updateProgressBars);
            artistryInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 100) this.value = 100;
                updateProgressBars();
            });
        }

        if (cultureInput) {
            cultureInput.addEventListener('input', updateProgressBars);
            cultureInput.addEventListener('change', function() {
                let value = parseInt(this.value) || 0;
                if (value < 0) this.value = 0;
                if (value > 100) this.value = 100;
                updateProgressBars();
            });
        }

        // Инициализация
        updateProgressBars();

        // Валидация формы
        const form = document.getElementById('evaluation-form');
        if (form) {
            form.addEventListener('submit', function(e) {
                const mastery = parseInt(masteryInput.value) || 0;
                const artistry = parseInt(artistryInput.value) || 0;
                const culture = parseInt(cultureInput.value) || 0;

                // Проверка диапазонов
                if (mastery < 0 || mastery > 100) {
                    e.preventDefault();
                    alert('Оценка "Мастерство" должна быть в диапазоне 0-100');
                    masteryInput.focus();
                    return;
                }

                if (artistry < 0 || artistry > 100) {
                    e.preventDefault();
                    alert('Оценка "Артистизм" должна быть в диапазоне 0-100');
                    artistryInput.focus();
                    return;
                }

                if (culture < 0 || culture > 100) {
                    e.preventDefault();
                    alert('Оценка "Сценическая культура" должна быть в диапазоне 0-100');
                    cultureInput.focus();
                    return;
                }

                // Подтверждение завершения
                if (e.submitter && e.submitter.name === 'complete') {
                    const total = mastery + artistry + culture;
                    if (total === 0) {
                        if (!confirm('Вы собираетесь поставить общий балл 0. Вы уверены?')) {
                            e.preventDefault();
                            return;
                        }
                    }

                    if (!confirm('Вы уверены, что хотите завершить оценку? После завершения изменить оценку будет невозможно.')) {
                        e.preventDefault();
                        return;
                    }
                }
            });
        }
    });
</script>