<?php
/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\helpers\Html;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-full">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?= Html::encode($this->title) ?> | Конкурсная платформа</title>
        <?php $this->head() ?>

        <!-- Tailwind CSS -->
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">

        <style>
            /* Стили для скрытия скроллбара в сайдбаре */
            nav::-webkit-scrollbar {
                width: 0; /* Скрыть скроллбар для WebKit браузеров */
                background: transparent; /* Сделать фон прозрачным */
            }

            nav {
                scrollbar-width: none; /* Скрыть скроллбар для Firefox */
                -ms-overflow-style: none; /* Скрыть скроллбар для IE и Edge */
            }

            /* Для старых версий некоторых браузеров */
            nav {
                overflow: -moz-scrollbars-none;
            }
            body {
                font-family: 'Ubuntu', sans-serif;
            }
            .menu-divider {
                height: 2px;
                background: rgba(0, 0, 0, 0.1);
                margin: 0.5rem 1.5rem;
            }
        </style>
    </head>
    <body class="bg-gray-50 h-full">
    <?php $this->beginBody() ?>

    <!-- Основной контейнер -->
    <div class="flex h-full">
        <!-- Кнопка мобильного меню -->
        <div class="md:hidden">
            <button id="mobile-menu-button" class="p-4 fixed top-0 left-0 z-30">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
        </div>

        <!-- Боковое меню (сайдбар) как в дизайн-проекте -->
        <div id="sidebar" class="bg-white shadow-lg w-64 min-h-screen fixed md:static transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-20">
            <div class="p-6 border-b border-gray-100">
                <h1 class="text-2xl font-bold text-gray-800">ВизартКонкурсы</h1>
                <?php if (!Yii::$app->user->isGuest): ?>
                    <p class="text-sm text-gray-600 mt-1">
                        <br>
                        <span class="ml-2 px-2 py-1 bg-blue-100 text-blue-800 text-xs rounded-full">
                        <?= Html::encode(Yii::$app->user->identity->role) ?>
                    </span>
                    </p>
                <?php endif; ?>
            </div>

            <nav class="mt-2 overflow-y-auto h-[calc(100vh-8rem)]">
                <!-- Основные пункты меню -->
                <a href="<?= Yii::$app->homeUrl ?>"
                   class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                    📊 Главная
                </a>

                <div class="menu-divider"></div>

                <?php if (!Yii::$app->user->isGuest): ?>
                    <?php $role = Yii::$app->user->identity->role; ?>

                    <!-- Меню для участника -->
                    <?php if ($role === 'participant'): ?>
                        <a href="<?= \yii\helpers\Url::to(['/application/index']) ?>"
                           class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📋 Мои заявки
                        </a>

                        <a href="<?= \yii\helpers\Url::to(['/contest/index']) ?>"
                           class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            🏆 Активные конкурсы
                        </a>

                        <!-- Меню для эксперта -->
                    <?php elseif ($role === 'expert'): ?>
                        <a href="<?= \yii\helpers\Url::to(['/expert/index']) ?>"
                           class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📝 Экспертные заявки
                        </a>


                        <!-- Меню для администратора -->
                    <?php elseif ($role === 'admin'): ?>
                        <!-- Конкурсы -->
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Конкурсы
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/contests']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📋 Все конкурсы
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/admin/contest-create']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            ➕ Создать конкурс
                        </a>

                        <div class="menu-divider"></div>

                        <!-- Пользователи -->
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Пользователи
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/users']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            👥 Все пользователи
                        </a>


                        <div class="menu-divider"></div>

                        <!-- Заявки -->
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Заявки
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/applications']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📄 Все заявки
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/admin/evaluations']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            ⭐ Оценка заявок
                        </a>

                        <div class="menu-divider"></div>

                        <!-- Справочники -->
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Справочники
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/nominations']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            🏅 Номинации
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/admin/age-categories']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            🎂 Возрастные категории
                        </a>

                        <div class="menu-divider"></div>

                        <!-- Эксперты -->
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Эксперты
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/expert-assignments']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📋 Назначения экспертов
                        </a>
                        <a href="<?= \yii\helpers\Url::to(['/admin/assign-expert']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            ➕ Назначить эксперта
                        </a>
                        <div class="menu-divider"></div>
                        <div class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                            Уведомления
                        </div>
                        <a href="<?= \yii\helpers\Url::to(['/admin/notifications']) ?>"
                           class="nav-link block py-2 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                            📋 Создать уведомление
                        </a>

                    <?php endif; ?>

                    <div class="menu-divider"></div>

                    <!-- Общие пункты для всех авторизованных -->
                    <a href="<?= \yii\helpers\Url::to(['/notification/index']) ?>"
                       class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                        🔔 Уведомления
                        <?php
                        // Можно добавить счётчик непрочитанных
                        $unreadCount = \app\models\Notification::find()
                            ->where(['user_id' => Yii::$app->user->id, 'is_read' => false])
                            ->count();
                        if ($unreadCount > 0): ?>
                            <span class="bg-red-500 text-white text-xs rounded-full px-2 py-1 ml-2"><?= $unreadCount ?></span>
                        <?php endif; ?>
                    </a>

                    <a href="<?= \yii\helpers\Url::to(['/user/profile']) ?>"
                       class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                        👤 Личный кабинет
                    </a>

                    <div class="menu-divider"></div>

                    <!-- Выход -->
                    <div class="px-6 py-3">
                        <?= Html::beginForm(['/site/logout'], 'post', ['class' => 'w-full']) ?>
                        <?= Html::submitButton('🚪 Выйти (' . Html::encode(Yii::$app->user->identity->login) . ')', [
                            'class' => 'w-full text-left text-red-600 hover:text-red-800 hover:bg-red-50 py-2 px-3 rounded transition-colors cursor-pointer'
                        ]) ?>
                        <?= Html::endForm() ?>
                    </div>
                <?php else: ?>
                    <!-- Меню для гостей -->
                    <a href="<?= \yii\helpers\Url::to(['/site/login']) ?>"
                       class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                        🔑 Вход
                    </a>
                    <a href="<?= \yii\helpers\Url::to(['/site/register']) ?>"
                       class="nav-link block py-3 px-6 text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors">
                        📝 Регистрация
                    </a>
                <?php endif; ?>

                <!-- Контакты (для всех) -->

                <!-- Информация о системе -->

            </nav>
        </div>

        <!-- Основной контент -->
        <div class="flex-1 flex flex-col md:ml-64" style="margin-left: 1rem">
            <!-- Всплывающие уведомления -->
            <?= Alert::widget() ?>

            <!-- Контент страницы -->
            <main class="flex-1 p-4 md:p-6 overflow-y-auto">
                <?= $content ?>
            </main>

            <!-- Подвал (опционально) -->
            <!--
        <footer class="bg-white border-t border-gray-200 p-4 text-center text-sm text-gray-600">
            <p>© <?= date('Y') ?> Конкурсная платформа. Все права защищены.</p>
        </footer>
        -->
        </div>
    </div>

    <!-- JavaScript для мобильного меню -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');
            const mobileMenuButton = document.getElementById('mobile-menu-button');

            // Мобильное меню
            if (mobileMenuButton) {
                mobileMenuButton.addEventListener('click', function() {
                    sidebar.classList.toggle('-translate-x-full');
                });
            }

            // Закрытие меню при клике на контент (на мобильных)
            const mainContent = document.querySelector('main');
            if (mainContent && window.innerWidth < 768) {
                mainContent.addEventListener('click', function() {
                    if (!sidebar.classList.contains('-translate-x-full')) {
                        sidebar.classList.add('-translate-x-full');
                    }
                });
            }

            // Активный пункт меню
            const currentPath = window.location.pathname;
            const navLinks = document.querySelectorAll('.nav-link');

            navLinks.forEach(link => {
                const linkPath = new URL(link.href).pathname;
                if (currentPath === linkPath ||
                    (currentPath.startsWith(linkPath) && linkPath !== '/')) {
                    link.classList.add('bg-blue-50', 'text-blue-600', 'font-medium');
                    link.classList.remove('text-gray-700', 'hover:bg-blue-50');
                }
            });

            // Адаптация к размеру экрана
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 768) {
                    sidebar.classList.remove('-translate-x-full');
                } else {
                    sidebar.classList.add('-translate-x-full');
                }
            });
        });
    </script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>