<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\ContactForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\captcha\Captcha;

$this->title = 'Контакты';
$this->params['breadcrumbs'][] = $this->title;
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>
    </div>

    <!-- Успешное сообщение после отправки -->
<?php if (Yii::$app->session->hasFlash('contactFormSubmitted')): ?>

    <div class="bg-white rounded-xl shadow-md p-8 mb-8">
        <div class="flex items-center mb-4">
            <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mr-4">
                <span class="text-2xl text-green-600">✓</span>
            </div>
            <div>
                <h3 class="text-xl font-semibold text-gray-800">Спасибо за обращение!</h3>
                <p class="text-gray-600">Мы ответим вам как можно скорее.</p>
            </div>
        </div>

        <?php if (Yii::$app->mailer->useFileTransport): ?>
            <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg mt-4">
                <p class="text-sm text-blue-700">
                    <strong>Режим разработки:</strong> Email не отправляется, а сохраняется как файл в
                    <code><?= Yii::getAlias(Yii::$app->mailer->fileTransportPath) ?></code>
                </p>
            </div>
        <?php endif; ?>

        <div class="mt-6">
            <a href="<?= Yii::$app->homeUrl ?>"
               class="inline-block bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors">
                Вернуться на главную
            </a>
        </div>
    </div>

<?php else: ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Контактная информация (левая колонка) -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-md p-6 mb-6">
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Контактная информация</h3>

                <div class="space-y-4">
                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-blue-600">📍</span>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Адрес</p>
                            <p class="text-gray-600">г. Москва, ул. Примерная, д. 123</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-blue-600">📞</span>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Телефон</p>
                            <p class="text-gray-600">+7 (999) 123-45-67</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-blue-600">✉️</span>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Email</p>
                            <p class="text-gray-600">info@конкурсная-платформа.рф</p>
                        </div>
                    </div>

                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-blue-600">🕐</span>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Время работы</p>
                            <p class="text-gray-600">Пн-Пт: 9:00 - 18:00</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Дополнительный блок -->
            <div class="bg-gradient-to-r from-blue-50 to-gray-50 rounded-xl p-6 border border-blue-100">
                <h4 class="font-semibold text-gray-800 mb-2">Нужна срочная помощь?</h4>
                <p class="text-sm text-gray-600 mb-3">Обратитесь в техническую поддержку</p>
                <button class="w-full bg-white border border-blue-300 text-blue-600 py-2 rounded-lg hover:bg-blue-50 transition-colors">
                    Чат с поддержкой
                </button>
            </div>
        </div>

        <!-- Форма обратной связи (правая колонка) -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="mb-6">
                    <h3 class="text-xl font-semibold text-gray-800 mb-2">Форма обратной связи</h3>
                    <p class="text-gray-600">
                        Если у вас есть деловые предложения или другие вопросы, пожалуйста, заполните следующую форму, чтобы связаться с нами. Спасибо.
                    </p>
                </div>

                <?php $form = ActiveForm::begin([
                    'id' => 'contact-form',
                    'enableClientValidation' => true,
                    'options' => ['class' => 'space-y-6']
                ]); ?>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <?= $form->field($model, 'name', [
                        'options' => ['class' => ''],
                        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                        'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'],
                    ])->textInput(['autofocus' => true])->label('Имя *') ?>

                    <?= $form->field($model, 'email', [
                        'options' => ['class' => ''],
                        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                        'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'],
                    ])->label('Email *') ?>
                </div>

                <?= $form->field($model, 'subject', [
                    'options' => ['class' => ''],
                    'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                    'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'],
                ])->label('Тема *') ?>

                <?= $form->field($model, 'body', [
                    'options' => ['class' => ''],
                    'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                    'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500', 'rows' => 5],
                ])->textarea(['rows' => 6])->label('Сообщение *') ?>

                <!-- CAPTCHA в стиле дизайн-проекта -->
                <?= $form->field($model, 'verifyCode', [
                    'options' => ['class' => ''],
                    'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                ])->widget(Captcha::class, [
                    'template' => '
                        <div class="flex flex-col md:flex-row items-start md:items-center gap-4">
                            <div class="flex-shrink-0">{image}</div>
                            <div class="flex-grow">
                                <div class="text-sm text-gray-600 mb-2">Введите текст с картинки</div>
                                {input}
                            </div>
                        </div>',
                    'options' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'],
                    'imageOptions' => ['class' => 'rounded-lg border border-gray-300']
                ])->label('Проверочный код') ?>

                <!-- Кнопки отправки -->
                <div class="flex space-x-4 pt-4">
                    <?= Html::submitButton('Отправить сообщение', [
                        'class' => 'flex-1 bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium',
                        'name' => 'contact-button'
                    ]) ?>

                    <button type="reset"
                            class="flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 transition-colors">
                        Очистить форму
                    </button>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>

<?php endif; ?>