<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Сменить пароль</h2>
</div>

<div class="bg-white rounded-xl shadow-md p-6 max-w-md">
    <?php use yii\helpers\Html;
    use yii\widgets\ActiveForm;

    $form = ActiveForm::begin(['options' => ['class' => 'space-y-6']]); ?>

    <?= $form->field($model, 'currentPassword', [
        'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg']
    ])->passwordInput()->label('Текущий пароль *') ?>

    <?= $form->field($model, 'newPassword', [
        'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg']
    ])->passwordInput()->label('Новый пароль *') ?>

    <?= $form->field($model, 'newPasswordRepeat', [
        'inputOptions' => ['class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg']
    ])->passwordInput()->label('Повторите новый пароль *') ?>

    <div class="mt-8 flex space-x-4">
        <?= Html::submitButton('Сохранить', [
            'class' => 'flex-1 bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700'
        ]) ?>
        <?= Html::a('Отмена', ['user/profile'], [
            'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg text-center'
        ]) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>