<?php
use yii\helpers\Html;
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Личный кабинет</h2>
</div>

<!-- Основной контент как в дизайн-проекте -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Левая колонка с данными пользователя -->
    <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
        <h3 class="text-2xl font-bold text-gray-800 mb-6">Личные данные</h3>

        <!-- Сетка данных как в дизайн-проекте -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Имя -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Имя</label>
                <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                    <?= Html::encode($model->name) ?>
                </div>
            </div>

            <!-- Фамилия -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Фамилия</label>
                <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                    <?= Html::encode($model->surname) ?>
                </div>
            </div>

            <!-- Отчество -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Отчество</label>
                <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                    <?= Html::encode($model->patronymic) ?>
                </div>
            </div>

            <!-- Логин -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Логин</label>
                <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                    <?= Html::encode($model->login) ?>
                </div>
            </div>

            <!-- Email -->
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                    <?= Html::encode($model->email) ?>
                </div>
            </div>

            <!-- Дополнительные поля (если есть) -->
            <?php if (isset($model->phone)): ?>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Телефон</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= Html::encode($model->phone) ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (isset($model->created_at)): ?>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Дата регистрации</label>
                    <div class="text-gray-900 bg-gray-50 rounded-lg px-4 py-3 border border-gray-200">
                        <?= Yii::$app->formatter->asDate($model->created_at, 'long') ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Кнопки действий в стиле дизайн-проекта -->
        <div class="mt-8 flex space-x-4">
            <?= Html::a('Редактировать профиль', ['user/edit'], [
                'class' => 'bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium'
            ]) ?>

            <?= Html::a('Сменить пароль', ['user/change-password'], [
                'class' => 'border border-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-50 transition-colors font-medium'
            ]) ?>
        </div>
    </div>
</div>

